/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.fineTune.job;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.fineTune.job.HyperParameters;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FineTuneJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FineTuneJob.class);
    private String model;
    @JsonProperty(value="training_file")
    private String trainingFile;
    @JsonProperty(value="hyperparameters")
    private HyperParameters hyperParameters;
    private String suffix;
    @JsonProperty(value="validation_file")
    private String validationFile;

    public static FineTuneJobBuilder builder() {
        return new FineTuneJobBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getTrainingFile() {
        return this.trainingFile;
    }

    public HyperParameters getHyperParameters() {
        return this.hyperParameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public FineTuneJob() {
    }

    public FineTuneJob(String model, String trainingFile, HyperParameters hyperParameters, String suffix, String validationFile) {
        this.model = model;
        this.trainingFile = trainingFile;
        this.hyperParameters = hyperParameters;
        this.suffix = suffix;
        this.validationFile = validationFile;
    }

    public static class FineTuneJobBuilder {
        private String model;
        private String trainingFile;
        private HyperParameters hyperParameters;
        private String suffix;
        private String validationFile;

        FineTuneJobBuilder() {
        }

        public FineTuneJobBuilder model(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="training_file")
        public FineTuneJobBuilder trainingFile(String trainingFile) {
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="hyperparameters")
        public FineTuneJobBuilder hyperParameters(HyperParameters hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        public FineTuneJobBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuneJobBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuneJob build() {
            return new FineTuneJob(this.model, this.trainingFile, this.hyperParameters, this.suffix, this.validationFile);
        }

        public String toString() {
            return "FineTuneJob.FineTuneJobBuilder(model=" + this.model + ", trainingFile=" + this.trainingFile + ", hyperParameters=" + this.hyperParameters + ", suffix=" + this.suffix + ", validationFile=" + this.validationFile + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO_1106("gpt-3.5-turbo-1106"),
        GPT_3_5_TURBO_0613("gpt-3.5-turbo-0613"),
        BABBAGE_002("babbage-002"),
        GPT_4_0613("gpt-4-0613"),
        DAVINCI_002("davinci-002");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

