/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.fineTune.job;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HyperParameters
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HyperParameters.class);
    @JsonProperty(value="batch_size")
    private String batchSize;
    @JsonProperty(value="learning_rate_multiplier")
    private String learningRateMultiplier;
    @JsonProperty(value="n_epochs")
    private String nEpochs;

    public static HyperParametersBuilder builder() {
        return new HyperParametersBuilder();
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public String getLearningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public String getNEpochs() {
        return this.nEpochs;
    }

    public HyperParameters() {
    }

    public HyperParameters(String batchSize, String learningRateMultiplier, String nEpochs) {
        this.batchSize = batchSize;
        this.learningRateMultiplier = learningRateMultiplier;
        this.nEpochs = nEpochs;
    }

    public static class HyperParametersBuilder {
        private String batchSize;
        private String learningRateMultiplier;
        private String nEpochs;

        HyperParametersBuilder() {
        }

        @JsonProperty(value="batch_size")
        public HyperParametersBuilder batchSize(String batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @JsonProperty(value="learning_rate_multiplier")
        public HyperParametersBuilder learningRateMultiplier(String learningRateMultiplier) {
            this.learningRateMultiplier = learningRateMultiplier;
            return this;
        }

        @JsonProperty(value="n_epochs")
        public HyperParametersBuilder nEpochs(String nEpochs) {
            this.nEpochs = nEpochs;
            return this;
        }

        public HyperParameters build() {
            return new HyperParameters(this.batchSize, this.learningRateMultiplier, this.nEpochs);
        }

        public String toString() {
            return "HyperParameters.HyperParametersBuilder(batchSize=" + this.batchSize + ", learningRateMultiplier=" + this.learningRateMultiplier + ", nEpochs=" + this.nEpochs + ")";
        }
    }
}

