/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.images;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Image
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Image.class);
    private String prompt;
    private String model;
    private String quality;
    private Integer n;
    private String size;
    private String style;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private String user;

    private static String $default$model() {
        return Model.DALL_E_3.getName();
    }

    public static ImageBuilder builder() {
        return new ImageBuilder();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getModel() {
        return this.model;
    }

    public String getQuality() {
        return this.quality;
    }

    public Integer getN() {
        return this.n;
    }

    public String getSize() {
        return this.size;
    }

    public String getStyle() {
        return this.style;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public Image() {
        this.model = Image.$default$model();
    }

    public Image(String prompt, String model, String quality, Integer n, String size, String style, String responseFormat, String user) {
        this.prompt = prompt;
        this.model = model;
        this.quality = quality;
        this.n = n;
        this.size = size;
        this.style = style;
        this.responseFormat = responseFormat;
        this.user = user;
    }

    public static class ImageBuilder {
        private String prompt;
        private boolean model$set;
        private String model$value;
        private String quality;
        private Integer n;
        private String size;
        private String style;
        private String responseFormat;
        private String user;

        ImageBuilder() {
        }

        public ImageBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public ImageBuilder model(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public ImageBuilder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public ImageBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ImageBuilder size(String size) {
            this.size = size;
            return this;
        }

        public ImageBuilder style(String style) {
            this.style = style;
            return this;
        }

        @JsonProperty(value="response_format")
        public ImageBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ImageBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Image build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Image.$default$model();
            }
            return new Image(this.prompt, model$value, this.quality, this.n, this.size, this.style, this.responseFormat, this.user);
        }

        public String toString() {
            return "Image.ImageBuilder(prompt=" + this.prompt + ", model$value=" + this.model$value + ", quality=" + this.quality + ", n=" + this.n + ", size=" + this.size + ", style=" + this.style + ", responseFormat=" + this.responseFormat + ", user=" + this.user + ")";
        }
    }

    public static enum Style {
        VIVID("vivid"),
        NATURAL("natural");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Style(String name) {
            this.name = name;
        }
    }

    public static enum Quality {
        STANDARD("standard"),
        HD("hd");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Quality(String name) {
            this.name = name;
        }
    }

    public static enum Model {
        DALL_E_2("dall-e-2"),
        DALL_E_3("dall-e-3");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

