/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.sse;

import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.OpenAiStreamClient;
import com.unfbx.chatgpt.entity.chat.BaseMessage;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.FunctionCall;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.plugin.PluginAbstract;
import com.unfbx.chatgpt.plugin.PluginParam;
import java.util.Objects;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginListener<R extends PluginParam, T>
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(PluginListener.class);
    private String arguments = "";
    private OpenAiStreamClient client;
    private EventSourceListener eventSourceListener;
    private PluginAbstract<R, T> plugin;
    private ChatCompletion chatCompletion;

    private String getArguments() {
        return this.arguments;
    }

    public PluginListener(OpenAiStreamClient client, EventSourceListener eventSourceListener, PluginAbstract<R, T> plugin, ChatCompletion chatCompletion) {
        this.client = client;
        this.eventSourceListener = eventSourceListener;
        this.plugin = plugin;
        this.chatCompletion = chatCompletion;
    }

    public void onClosedAfter() {
        log.debug("\u6784\u9020\u7684\u65b9\u6cd5\u503c\uff1a{}", (Object)this.getArguments());
        PluginParam realFunctionParam = (PluginParam)JSONUtil.toBean((String)this.getArguments(), this.plugin.getR());
        T tq = this.plugin.func(realFunctionParam);
        FunctionCall functionCall = FunctionCall.builder().arguments(this.getArguments()).name(this.plugin.getFunction()).build();
        this.chatCompletion.getMessages().add(Message.builder().role(BaseMessage.Role.ASSISTANT).content("function_call").functionCall(functionCall).build());
        this.chatCompletion.getMessages().add(Message.builder().role(BaseMessage.Role.FUNCTION).name(this.plugin.getFunction()).content(this.plugin.content(tq)).build());
        this.chatCompletion.setFunctionCall(null);
        this.chatCompletion.setFunctions(null);
        this.client.streamChatCompletion(this.chatCompletion, this.eventSourceListener);
    }

    public final void onEvent(EventSource eventSource, String id, String type, String data) {
        log.debug("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)data);
        if ("[DONE]".equals(data)) {
            log.debug("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668\u8fd4\u56de\u6570\u636e\u7ed3\u675f\u4e86");
            return;
        }
        ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)JSONUtil.toBean((String)data, ChatCompletionResponse.class);
        if (Objects.nonNull(chatCompletionResponse.getChoices().get(0).getDelta().getFunctionCall())) {
            this.arguments = this.arguments + chatCompletionResponse.getChoices().get(0).getDelta().getFunctionCall().getArguments();
        }
    }

    public final void onClosed(EventSource eventSource) {
        log.debug("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668\u5173\u95ed\u8fde\u63a5...");
        this.onClosedAfter();
    }

    public void onOpen(EventSource eventSource, Response response) {
        log.debug("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668\u5efa\u7acb\u8fde\u63a5...");
    }

    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        if (Objects.isNull(response)) {
            log.error("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668,\u8fde\u63a5\u5f02\u5e38:{}", t);
            eventSource.cancel();
            return;
        }
        ResponseBody body = response.body();
        if (Objects.nonNull(body)) {
            log.error("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668,\u8fde\u63a5\u5f02\u5e38data\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", (Object)body.string(), (Object)t);
        } else {
            log.error("\u63d2\u4ef6\u5f00\u53d1\u8fd4\u56de\u4fe1\u606f\u6536\u96c6sse\u76d1\u542c\u5668,\u8fde\u63a5\u5f02\u5e38data\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", (Object)response, (Object)t);
        }
        eventSource.cancel();
    }
}

