/*
 * Decompiled with CFR 0.152.
 */
package com.union.communicate;

import com.union.communicate.SocketIO;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;

public class ConnectPool {
    private static ConnectPool instance = null;
    private static Map<String, ConnectPool> connectPoolMap = new HashMap<String, ConnectPool>();
    private PriorityBlockingQueue<SocketIO> pbQueue = null;
    private ClientPCollator clientCollator = null;
    private int count = 0;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ConnectPool getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ConnectPool();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ConnectPool getInstance(String HsmHost, int HsmPort, int poolNumber) {
        Object object = lock;
        synchronized (object) {
            if (connectPoolMap.get(HsmHost) == null) {
                instance = new ConnectPool(HsmHost, HsmPort, poolNumber);
                connectPoolMap.put(HsmHost, instance);
            }
            return connectPoolMap.get(HsmHost);
        }
    }

    private ConnectPool() {
        this.initialize(1);
    }

    private ConnectPool(String HsmHost, int HsmPort, int poolNumber) {
        this.initialize(poolNumber);
    }

    public void initialize(int poolNumber) {
        try {
            this.count = poolNumber;
            this.clientCollator = new ClientPCollator();
            this.pbQueue = new PriorityBlockingQueue<Object>(this.count + 1, this.clientCollator);
            int i = 0;
            while (i < this.count) {
                this.pbQueue.put(new SocketIO(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void removeConnect(SocketIO socket) {
        this.pbQueue.remove(socket);
    }

    public synchronized SocketIO getConnect() {
        SocketIO socket = null;
        try {
            socket = this.pbQueue.take();
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
        return socket;
    }

    public void putConnect(SocketIO socket) {
        if (this.pbQueue.size() < this.count) {
            this.pbQueue.put(socket);
        }
    }

    class ClientPCollator
    implements Comparator<Object> {
        ClientPCollator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof SocketIO && o2 instanceof SocketIO) {
                int prior2;
                SocketIO client1 = (SocketIO)o1;
                SocketIO client2 = (SocketIO)o2;
                int prior1 = client1.IsConnected() ? 1 : 2;
                int n = prior2 = client2.IsConnected() ? 1 : 2;
                if (prior1 > prior2) {
                    return 1;
                }
                if (prior1 == prior2) {
                    return 0;
                }
                return -1;
            }
            ClassCastException cce = new ClassCastException("\u6bd4\u8f83\u65f6\u5e94\u8f93\u5165UnionSocket\u7c7b");
            throw cce;
        }
    }
}

