/*
 * Decompiled with CFR 0.152.
 */
package com.union.essc;

import com.union.bean.Body;
import com.union.bean.Head;
import com.union.bean.Union;
import com.union.communicate.CommWithServer;
import com.union.essc.TUnionTransInfo;
import com.union.essc.UnionErrCode;
import com.union.essc.UnionUtil;
import com.union.xml.xstreamXML;
import java.util.List;

public class UnionEsscAPI {
    private int longOrShortConn = 0;
    private Head h = new Head();
    private List<String> ipList;
    private List<Integer> portList;
    private int timeout = 5;
    private int connNum = 30;

    public UnionEsscAPI(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.h.setSysID(sysID);
        this.h.setAppID(appID);
        this.connNum = 1;
        this.setLongOrShortConn(0);
        xstreamXML.registXstream(Union.class, Head.class, Body.class);
    }

    public UnionEsscAPI(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID, int connNum) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.h.setSysID(sysID);
        this.h.setAppID(appID);
        this.setLongOrShortConn(1);
        this.connNum = connNum > 300 ? 300 : connNum;
        xstreamXML.registXstream(Union.class, Head.class, Body.class);
    }

    public int getLongOrShortConn() {
        return this.longOrShortConn;
    }

    public void setLongOrShortConn(int longOrShortConn) {
        this.longOrShortConn = longOrShortConn;
    }

    public TUnionTransInfo unionAPIServiceE123(String keyName) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (keyName == null || keyName.equals("")) {
            transInfo.setLog("keyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setKeyName(keyName);
        this.h.setServiceCode("E123");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE170(String keyName, int dataFillMode, String hashID, String userID, String data) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (keyName == null || "".equals(keyName)) {
            transInfo.setLog("keyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setKeyName(keyName);
        b.setDataFillMode(String.valueOf(dataFillMode));
        b.setHashID(hashID);
        b.setUserID(userID);
        b.setData(data);
        this.h.setServiceCode("E170");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE171(int mode, String keyName, String pkValue, String algorithmID, String dataFillMode, String hashID, String userID, String data, String sign) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (mode >= 0) {
            b.setMode(String.valueOf(mode));
        }
        if (mode == 1) {
            if (keyName == null || "".equals(keyName)) {
                transInfo.setLog("keyName\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setKeyName(keyName);
        }
        if (mode == 2) {
            if (pkValue == null || "".equals(pkValue)) {
                transInfo.setLog("pkValue\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setPkValue(pkValue);
            if (algorithmID == null || "".equals(algorithmID)) {
                transInfo.setLog("algorithmID\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setAlgorithmID(algorithmID);
        }
        b.setDataFillMode(dataFillMode);
        b.setHashID(hashID);
        b.setUserID(userID);
        if (data == null || data.equals("")) {
            transInfo.setLog("data\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setData(data);
        b.setSign(sign);
        this.h.setServiceCode("E171");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE172(int mode, String keyName, String pkValue, String algorithmID, String pkExponent, String dataFillMode, String plainData) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (mode >= 0) {
            b.setMode(String.valueOf(mode));
        }
        if (mode == 1) {
            if (keyName == null || "".equals(keyName)) {
                transInfo.setLog("keyName\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setKeyName(keyName);
        }
        if (mode == 2) {
            if (pkValue == null || "".equals(pkValue)) {
                transInfo.setLog("pkValue\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setPkValue(pkValue);
            if (algorithmID == null || "".equals(algorithmID)) {
                transInfo.setLog("algorithmID\u4e3a\u7a7a");
                transInfo.setIsSuccess(0);
                transInfo.setResponseCode(UnionErrCode.errCodeParameter);
                return transInfo;
            }
            b.setAlgorithmID(algorithmID);
            if ("RSA".equals(algorithmID)) {
                b.setPkExponent(pkExponent);
            }
        }
        b.setDataFillMode(dataFillMode);
        if (plainData == null || "".equals(plainData)) {
            transInfo.setLog("plainData\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setPlainData(plainData);
        this.h.setServiceCode("E172");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE173(String keyName, String cipherDataLen, int vkIndex, String algorithmID, String dataFillMode, String cipherData) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (keyName == null || "".equals(keyName)) {
            b.setVkIndex(String.valueOf(vkIndex));
            b.setAlgorithmID(algorithmID);
        } else {
            b.setKeyName(keyName);
        }
        if (dataFillMode == null || "".equals(dataFillMode)) {
            transInfo.setLog("dataFillMode\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setDataFillMode(dataFillMode);
        if (!UnionUtil.isNum(cipherDataLen)) {
            transInfo.setLog("cipListherDataLen\u4e0d\u5168\u4e3a\u6570\u5b57");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setCipherDataLen(cipherDataLen);
        if (cipherData == null || "".equals(cipherData)) {
            transInfo.setLog("cipListherData\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setCipherData(cipherData);
        this.h.setServiceCode("E173");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE201(String pkKeyName, String zpkKeyName, String accNo, String pinByPK, int format) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (pkKeyName == null || pkKeyName.equals("")) {
            transInfo.setLog("pkKeyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setPkKeyName(pkKeyName);
        if (zpkKeyName == null || zpkKeyName.equals("")) {
            transInfo.setLog("zpkKeyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setZpkKeyName(zpkKeyName);
        if (accNo == null || accNo.equals("")) {
            transInfo.setLog("accNo\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setAccNo(accNo);
        if (pinByPK == null || pinByPK.equals("")) {
            transInfo.setLog("pinByPK\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setPinByPK(pinByPK);
        b.setFormat(String.valueOf(format));
        this.h.setServiceCode("E201");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }

    public TUnionTransInfo unionAPIServiceE202(String pkKeyName, String zpkKeyName, String accNo, String pinByPK, int format) {
        TUnionTransInfo transInfo = new TUnionTransInfo();
        Body b = new Body();
        if (pkKeyName == null || pkKeyName.equals("")) {
            transInfo.setLog("pkKeyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setPkKeyName(pkKeyName);
        if (zpkKeyName == null || zpkKeyName.equals("")) {
            transInfo.setLog("zpkKeyName\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setZpkKeyName(zpkKeyName);
        if (accNo == null || accNo.equals("")) {
            transInfo.setLog("accNo\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setAccNo(accNo);
        if (pinByPK == null || pinByPK.equals("")) {
            transInfo.setLog("pinByPK\u4e3a\u7a7a");
            transInfo.setIsSuccess(0);
            transInfo.setResponseCode(UnionErrCode.errCodeParameter);
            return transInfo;
        }
        b.setPinByPK(pinByPK);
        b.setFormat(String.valueOf(format));
        this.h.setServiceCode("E202");
        CommWithServer commWithServer = new CommWithServer(this.ipList, this.portList, this.timeout, this.connNum);
        transInfo = this.longOrShortConn == 0 ? commWithServer.UnionBitCommWithServerShortConn(this.h, b) : commWithServer.UnionBitCommWithServerLongConn(this.h, b);
        return transInfo;
    }
}

