/*
 * Decompiled with CFR 0.152.
 */
package com.union.essc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class UnionStr {
    public static String getCurrentTimeBuf() {
        SimpleDateFormat currentFullSystemDateTime = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeBuf = currentFullSystemDateTime.format(Calendar.getInstance().getTime());
        return timeBuf;
    }

    public static long getThreadid() {
        Thread current = Thread.currentThread();
        return current.getId();
    }

    public static long getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return Long.parseLong(df.format(new Date()));
    }

    public static String getEndTime(int intervalTime) {
        Calendar cal = Calendar.getInstance();
        cal.add(14, intervalTime * 1000);
        String endTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(cal.getTime());
        return endTime;
    }

    public static String bcdhex_to_aschex(byte[] bcdhex) {
        byte[] aschex = new byte[2];
        String res = "";
        String tmp = "";
        int i = 0;
        while (i < bcdhex.length) {
            aschex[1] = UnionStr.hexLowToAsc(bcdhex[i]);
            aschex[0] = UnionStr.hexHighToAsc(bcdhex[i]);
            tmp = new String(aschex);
            res = String.valueOf(res) + tmp;
            ++i;
        }
        return res;
    }

    public static byte hexLowToAsc(byte xxc) {
        xxc = (xxc = (byte)(xxc & 0xF)) < 10 ? (byte)(xxc + 48) : (byte)(xxc + 55);
        return xxc;
    }

    public static byte hexHighToAsc(int xxc) {
        xxc &= 0xF0;
        xxc = (xxc >>= 4) < 10 ? (xxc += 48) : (xxc += 55);
        return (byte)xxc;
    }

    public static byte[] aschex_to_bcdhex(String aschex) {
        byte[] aschexByte = aschex.getBytes();
        int j = 0;
        if (aschexByte.length % 2 == 0) {
            j = aschexByte.length / 2;
            byte[] resTmp = new byte[j];
            int i = 0;
            while (i < j) {
                resTmp[i] = UnionStr.ascToHex(aschexByte[2 * i], aschexByte[2 * i + 1]);
                ++i;
            }
            return resTmp;
        }
        j = aschexByte.length / 2 + 1;
        byte[] resTmp = new byte[j];
        int i = 0;
        while (i < j - 1) {
            resTmp[i] = UnionStr.ascToHex(aschexByte[2 * i], aschexByte[2 * i + 1]);
            ++i;
        }
        resTmp[j - 1] = UnionStr.ascToHex(aschexByte[2 * (j - 1)], (byte)0);
        return resTmp;
    }

    public static byte ascToHex(byte ch1, byte ch2) {
        byte ch = ch1 >= 65 ? (byte)(ch1 - 55 << 4) : (byte)(ch1 - 48 << 4);
        ch = ch2 >= 65 ? (byte)(ch | (byte)(ch2 - 55)) : (byte)(ch | (byte)(ch2 - 48));
        return ch;
    }

    public static String UnionXOR(String str1, String str2) {
        String tmpStr = "";
        int temp = 0;
        temp = str1.length() > str2.length() ? str2.length() : str1.length();
        int i = 0;
        while (i < temp) {
            char ch1 = str1.charAt(i);
            ch1 = ch1 >= 'A' && ch1 <= 'F' ? (char)(ch1 - 64 + 9) : (ch1 >= 'a' && ch1 <= 'f' ? (char)(ch1 - 96 + 9) : (char)(ch1 - 48));
            char ch2 = str2.charAt(i);
            ch2 = ch2 >= 'A' && ch2 <= 'F' ? (char)(ch2 - 64 + 9) : (ch2 >= 'a' && ch2 <= 'f' ? (char)(ch2 - 96 + 9) : (char)(ch2 - 48));
            ch1 = (char)(ch1 ^ ch2);
            ch1 = ch1 > '\t' ? (char)(64 + (ch1 - 9)) : (char)(ch1 + 48);
            tmpStr = String.valueOf(tmpStr) + ch1;
            ++i;
        }
        return tmpStr;
    }

    public static String getClientIpAddr() {
        String hostIp = "";
        try {
            hostIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostIp;
    }
}

