/*
 * Decompiled with CFR 0.152.
 */
package com.union.pufa;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class CodeUtils {
    private static final String DEFAULT_URL_ENCODING = "UTF-8";

    public static String byte2hex(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    public static byte[] hex2byte(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException("Hex Decoder exception", e);
        }
    }

    public static String base64Encode(byte[] input) {
        return Base64.encodeBase64String((byte[])input);
    }

    public static String base64UrlSafeEncode(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    public static byte[] base64Decode(String input) {
        return Base64.decodeBase64((String)input);
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported Encoding Exception", e);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported Encoding Exception", e);
        }
    }

    public static String htmlEscape(String html) {
        return StringEscapeUtils.escapeHtml((String)html);
    }

    public static String htmlUnescape(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml((String)htmlEscaped);
    }

    public static String xmlEscape(String xml) {
        return StringEscapeUtils.escapeXml((String)xml);
    }

    public static String xmlUnescape(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String md5String(String str) {
        return DigestUtils.md5Hex((String)str);
    }

    public static String sha1String(String str) {
        return DigestUtils.sha1Hex((String)str);
    }

    public static String asc2ascInt2hexasc(String str) {
        byte[] b = str.getBytes();
        int[] in = new int[b.length];
        int i = 0;
        while (i < in.length) {
            in[i] = b[i] & 0xFF;
            ++i;
        }
        StringBuffer sb = new StringBuffer(in.length);
        int j = 0;
        while (j < in.length) {
            sb.append(Integer.toString(in[j], 16));
            ++j;
        }
        return sb.toString();
    }

    public static String hexasc2ascInt2asc(String str) {
        int[] in = new int[str.length() / 2];
        int i = 0;
        while (i < in.length) {
            in[i] = Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        StringBuffer sb = new StringBuffer(in.length);
        int j = 0;
        while (j < in.length) {
            sb.append((char)in[j]);
            ++j;
        }
        return sb.toString();
    }

    public static String paddingRightStr(String str, char padc, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        int numc = length - str.length();
        StringBuffer rets = new StringBuffer(str);
        int i = 0;
        while (i < numc) {
            rets.append(padc);
            ++i;
        }
        return rets.toString();
    }
}

