/*
 * Decompiled with CFR 0.152.
 */
package com.union.pufa;

import com.union.essc.TUnionTransInfo;
import com.union.essc.UnionEsscAPI;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ControlManager {
    private static List<String> ipList = null;
    private static List<Integer> portList = null;
    private static UnionEsscAPI longApi = null;
    private static TUnionTransInfo transInfo = null;
    private String ip;
    private int port;
    Logger logger = Logger.getLogger(ControlManager.class);

    static {
        ipList = new ArrayList<String>();
        portList = new ArrayList<Integer>();
        longApi = new UnionEsscAPI(ipList, portList, 7, "TE", "ATM", 5);
    }

    public ControlManager(String ip, int port) {
        this.ip = ip;
        this.port = port;
        ipList.add(0, ip);
        portList.add(0, port);
    }

    public String vkSign(String keyName, int dataFillMode, String hashID, String userID, String data) {
        try {
            transInfo = longApi.unionAPIServiceE170(keyName, dataFillMode, hashID, userID, data);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u516c\u94a5\u52a0\u5bc6\u5931\u8d25: ", (Throwable)e);
        }
        return transInfo.getReturnBody().getSign();
    }

    public String pkVerify(String keyName, String hashID, String userID, String data, String sign) {
        try {
            transInfo = longApi.unionAPIServiceE171(1, keyName, "", "", "1", hashID, userID, data, sign);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u516c\u94a5\u52a0\u5bc6\u5931\u8d25: ", (Throwable)e);
        }
        return transInfo.getResponseRemark();
    }

    public String pkEncrypt(String keyName, String dataFillMode, String plainData) {
        try {
            transInfo = longApi.unionAPIServiceE172(1, keyName, "", "", "", dataFillMode, plainData);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u516c\u94a5\u52a0\u5bc6\u5931\u8d25: ", (Throwable)e);
        }
        System.out.println(transInfo.getResponseRemark());
        System.out.println(transInfo.getResponseCode());
        System.out.println(transInfo.getReturnBody().getCipherData());
        return transInfo.getReturnBody().getCipherData();
    }

    public String vkDecrypt(String keyName, String dataFillMode, String cipherData) {
        try {
            transInfo = longApi.unionAPIServiceE173(keyName, "" + cipherData.length(), 16, "RSA", dataFillMode, cipherData);
            System.out.println(transInfo.getResponseRemark());
            System.out.println(transInfo.getResponseCode());
            System.out.println(transInfo.getReturnBody().getPlainData());
        }
        catch (Exception e) {
            this.logger.error((Object)"\u670d\u52a1E173\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25: ", (Throwable)e);
        }
        return transInfo.getReturnBody().getPlainData();
    }

    public String pinTransForZpk(String pkKeyName, String zpkKeyName, String accNo, String pinByPk, int format) {
        try {
            transInfo = longApi.unionAPIServiceE201(pkKeyName, zpkKeyName, accNo, pinByPk, format);
            System.out.println(transInfo.getResponseRemark());
            System.out.println(transInfo.getResponseCode());
            System.out.println(transInfo.getLog());
            System.out.println(transInfo.getReturnBody().getPinByZPK());
        }
        catch (Exception e) {
            this.logger.error((Object)"E201\u6570\u5b57PIN\u8f6c\u6362(PK->ZPK)\u5931\u8d25: ", (Throwable)e);
        }
        return transInfo.getReturnBody().getPinByZPK();
    }

    public String charTransForZpk(String pkKeyName, String zpkKeyName, String accNo, String pinByPk, int format) {
        try {
            transInfo = longApi.unionAPIServiceE202(pkKeyName, zpkKeyName, accNo, pinByPk, format);
            System.out.println(transInfo.getResponseRemark());
            System.out.println(transInfo.getResponseCode());
            System.out.println(transInfo.getLog());
            System.out.println(transInfo.getReturnBody().getPinByZPK());
        }
        catch (Exception e) {
            this.logger.error((Object)"E202\u5b57\u7b26PIN\u8f6c\u6362(PK->ZPK)\u5931\u8d25: ", (Throwable)e);
        }
        return transInfo.getReturnBody().getPinByZPK();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

