/*
 * Decompiled with CFR 0.152.
 */
package com.union.pufa;

import com.union.pufa.CodeUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    private static final String ALGORITHOM = "RSA";
    private static final Provider DEFAULT_PROVIDER = new BouncyCastleProvider();
    private static final String SIGNATURE_MD5WITHRSA = "MD5withRSA";
    private static final String SIGNATURE_SHA1WITHRSA = "SHA1withRSA";
    private static final String SIGNATURE_ALGORITHM_DEFAULT = "NONEwithRSA";
    private static final String CIPHER_TRANSFORMATION_DEFAULT = "RSA/ECB/PKCS1Padding";
    private static final String HASHID_SHA1 = "01";
    private static final String HASHID_MD5 = "02";
    private static KeyPairGenerator keyPairGen = null;
    private static KeyFactory keyFactory = null;

    static {
        try {
            keyPairGen = KeyPairGenerator.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
            keyFactory = KeyFactory.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error(ex.getMessage());
        }
    }

    private RSAUtils() {
    }

    public static synchronized KeyPair generateRSAKeyPair(int keysize, BigInteger publicExponent) {
        try {
            keyPairGen.initialize(new RSAKeyGenParameterSpec(keysize, publicExponent), new SecureRandom());
            return keyPairGen.generateKeyPair();
        }
        catch (Exception ex) {
            LOGGER.error("\u751f\u6210\u6a21\u957f =" + keysize + "\uff0c\u6307\u6570=" + publicExponent + "\u7684RSA\u5bc6\u94a5\u5bf9\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static PrivateKey getRSAPrivateKey(String hexModulus, String hexPrivateExponent) {
        if (StringUtils.isBlank((String)hexModulus) || StringUtils.isBlank((String)hexPrivateExponent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("hexModulus and hexPrivateExponent cannot be empty. RSAPrivateKey value is null to return.");
            }
            return null;
        }
        BigInteger mbig = new BigInteger(hexModulus, 16);
        BigInteger ebig = new BigInteger(hexPrivateExponent, 16);
        RSAPrivateKeySpec prispec = new RSAPrivateKeySpec(mbig, ebig);
        try {
            return keyFactory.generatePrivate(prispec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("hexModulus or hexPrivateExponent value is invalid. return null(RSAPrivateKey).");
            return null;
        }
    }

    public static PublicKey getRSAPublidKey(String hexModulus, String hexPublicExponent) {
        if (StringUtils.isBlank((String)hexModulus) || StringUtils.isBlank((String)hexPublicExponent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("hexModulus and hexPublicExponent cannot be empty. return null(RSAPublicKey).");
            }
            return null;
        }
        BigInteger mbig = new BigInteger(hexModulus, 16);
        BigInteger ebig = new BigInteger(hexPublicExponent, 16);
        RSAPublicKeySpec pubspec = new RSAPublicKeySpec(mbig, ebig);
        try {
            return keyFactory.generatePublic(pubspec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("hexModulus or hexPublicExponent value is invalid. return null(RSAPublicKey).");
            return null;
        }
    }

    public static String getBase64CodeKey(Key key) {
        return CodeUtils.base64Encode(key.getEncoded());
    }

    public static String getNakedPublicKey(RSAPublicKey key) {
        return key.getModulus().toString(16).toUpperCase();
    }

    private static byte[] getAsn1Len(int len) {
        int ret = 0;
        byte[] buff = new byte[10];
        byte[] asn1Len = null;
        if (len > 65535) {
            return null;
        }
        if (len > 255) {
            buff[0] = -126;
            buff[1] = (byte)((len & 0xFF00) >> 8);
            buff[2] = (byte)(len & 0xFF);
            ret = 3;
        } else if ((len & 0x80) != 0) {
            buff[0] = -127;
            buff[1] = (byte)len;
            ret = 2;
        } else {
            buff[0] = (byte)len;
            ret = 1;
        }
        asn1Len = new byte[ret];
        System.arraycopy(buff, 0, asn1Len, 0, ret);
        return asn1Len;
    }

    public static byte[] getDerPK(byte[] pkModule, byte[] exp) {
        byte[] buff = new byte[4096];
        byte[] tbuff = new byte[4096];
        byte[] tmp = null;
        byte[] derPK = null;
        int offset = 0;
        int len = 0;
        int lenOfPkModule = pkModule.length;
        int lenOfExp = exp.length;
        if (pkModule == null || exp == null) {
            return null;
        }
        offset = 0;
        tbuff[offset] = 2;
        tmp = RSAUtils.getAsn1Len(lenOfPkModule + 1);
        System.arraycopy(tmp, 0, tbuff, ++offset, tmp.length);
        tbuff[offset += tmp.length] = 0;
        System.arraycopy(pkModule, 0, tbuff, ++offset, lenOfPkModule);
        tbuff[offset += lenOfPkModule] = 2;
        tmp = RSAUtils.getAsn1Len(lenOfExp);
        System.arraycopy(tmp, 0, tbuff, ++offset, tmp.length);
        System.arraycopy(exp, 0, tbuff, offset += tmp.length, lenOfExp);
        len = offset += lenOfExp;
        offset = 0;
        buff[offset] = 48;
        tmp = RSAUtils.getAsn1Len(len);
        System.arraycopy(tmp, 0, buff, ++offset, tmp.length);
        System.arraycopy(tbuff, 0, buff, offset += tmp.length, len);
        derPK = new byte[offset += len];
        System.arraycopy(buff, 0, derPK, 0, offset);
        return derPK;
    }

    public static String getDerPKWithAscHex(String pkModule, String exp) {
        if (pkModule == null || exp == null) {
            return null;
        }
        return CodeUtils.byte2hex(RSAUtils.getDerPK(CodeUtils.hex2byte(pkModule), CodeUtils.hex2byte(exp)));
    }

    public static PublicKey getPKfromDerPK(String racalPK) {
        int i;
        int bitsOfLenFlag;
        int lenOfNextPart;
        int offset;
        byte[] racalPKStr = null;
        if (racalPK == null) {
            return null;
        }
        racalPKStr = CodeUtils.hex2byte(racalPK);
        if (racalPKStr[offset = 0] != 48) {
            return null;
        }
        if ((racalPKStr[++offset] & 0xFF) <= 128) {
            lenOfNextPart = racalPKStr[offset] & 0xFF;
            ++offset;
        } else {
            bitsOfLenFlag = (racalPKStr[offset] & 0xFF) - 128;
            ++offset;
            i = 0;
            lenOfNextPart = 0;
            while (i < bitsOfLenFlag) {
                lenOfNextPart += racalPKStr[offset] & 0xFF;
                ++i;
                ++offset;
            }
        }
        if ((racalPKStr[offset] & 0xFF) != 2) {
            return null;
        }
        --lenOfNextPart;
        int lenOfPK = 0;
        if ((racalPKStr[++offset] & 0xFF) <= 128) {
            lenOfPK = racalPKStr[offset] & 0xFF;
            ++offset;
        } else {
            bitsOfLenFlag = (racalPKStr[offset] & 0xFF) - 128;
            ++offset;
            i = 0;
            lenOfPK = 0;
            while (i < bitsOfLenFlag) {
                lenOfPK += racalPKStr[offset] & 0xFF;
                ++i;
                ++offset;
            }
        }
        while (lenOfPK % 8 != 0) {
            if ((racalPKStr[offset] & 0xFF) != 0) {
                return null;
            }
            ++offset;
            --lenOfPK;
        }
        byte[] LPk = new byte[lenOfPK];
        System.arraycopy(racalPKStr, offset, LPk, 0, lenOfPK);
        String pk = CodeUtils.byte2hex(LPk);
        byte lenOfEval = 0;
        if (racalPKStr[offset += lenOfPK] != 2) {
            return null;
        }
        lenOfEval = racalPKStr[++offset];
        byte[] LPkEval = new byte[lenOfEval];
        System.arraycopy(racalPKStr, ++offset, LPkEval, 0, lenOfEval);
        return RSAUtils.getRSAPublidKey(pk, CodeUtils.byte2hex(LPkEval));
    }

    public static RSAPublicKey getRSAPublidKeyBybase64(String base64s) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(CodeUtils.base64Decode(base64s));
        RSAPublicKey publicKey = null;
        try {
            publicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("base64\u7f16\u7801=" + base64s + "\u8f6cRSA\u516c\u94a5\u5931\u8d25", (Throwable)e);
        }
        return publicKey;
    }

    public static RSAPrivateKey getRSAPrivateKeyBybase64(String base64s) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(CodeUtils.base64Decode(base64s));
        RSAPrivateKey privateKey = null;
        try {
            privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("base64\u7f16\u7801=" + base64s + "\u8f6cRSA\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
        return privateKey;
    }

    public static byte[] encrypt(Key key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION_DEFAULT, DEFAULT_PROVIDER);
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(Key key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION_DEFAULT, DEFAULT_PROVIDER);
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public static String encryptString(Key key, String plaintext) {
        if (key == null || plaintext == null) {
            return null;
        }
        byte[] data = plaintext.getBytes();
        try {
            byte[] en_data = RSAUtils.encrypt(key, data);
            return new String(Hex.encodeHex((byte[])en_data));
        }
        catch (Exception ex) {
            LOGGER.error(ex.getCause().getMessage());
            return null;
        }
    }

    public static String encryptStr4essc(Key key, String plaintext, String accNo, String encType) {
        if (key == null || plaintext == null) {
            return null;
        }
        if ("1".equals(encType)) {
            plaintext = CodeUtils.paddingRightStr(plaintext, 'F', 16);
        } else if ("0".equals(encType)) {
            plaintext = CodeUtils.asc2ascInt2hexasc(CodeUtils.paddingRightStr(plaintext, 'F', 16));
        }
        byte[] data = CodeUtils.hex2byte(plaintext);
        try {
            byte[] en_data = RSAUtils.encrypt(key, data);
            return new String(Hex.encodeHex((byte[])en_data)).toUpperCase();
        }
        catch (Exception ex) {
            LOGGER.error(ex.getCause().getMessage());
            return null;
        }
    }

    public static String decryptString(Key key, String encrypttext) {
        if (key == null || StringUtils.isBlank((String)encrypttext)) {
            return null;
        }
        try {
            byte[] en_data = Hex.decodeHex((char[])encrypttext.toCharArray());
            byte[] data = RSAUtils.decrypt(key, en_data);
            return new String(data);
        }
        catch (Exception ex) {
            LOGGER.error(String.format("\"%s\" Decryption failed. Cause: %s", encrypttext, ex.getCause().getMessage()));
            return null;
        }
    }

    public static String sign(RSAPrivateKey privatekey, String dataFillMode, String hashID, String data) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM_DEFAULT);
        if (HASHID_SHA1.equals(hashID)) {
            data = CodeUtils.sha1String(data).toUpperCase();
        } else if (HASHID_MD5.equals(hashID)) {
            data = CodeUtils.md5String(data).toUpperCase();
        }
        signature.initSign(privatekey);
        signature.update(data.getBytes());
        return CodeUtils.byte2hex(signature.sign()).toUpperCase();
    }

    public static boolean verifySign(PublicKey publicKey, String dataFillMode, String hashID, String data, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM_DEFAULT);
        if (HASHID_SHA1.equals(hashID)) {
            data = CodeUtils.sha1String(data).toUpperCase();
        } else if (HASHID_MD5.equals(hashID)) {
            data = CodeUtils.md5String(data).toUpperCase();
        }
        signature.initVerify(publicKey);
        signature.update(data.getBytes());
        return signature.verify(CodeUtils.hex2byte(sign.toUpperCase()));
    }
}

