/*
 * Decompiled with CFR 0.152.
 */
package com.union.pufa.zip;

import com.union.essc.UnionSocket;
import com.union.pufa.zip.UnionZip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZIPUtil
implements UnionZip {
    static Logger logger = Logger.getLogger(UnionSocket.class);
    private static ZIPUtil instance = new ZIPUtil();
    private static final int BUFFEREDSIZE = 1024;

    public static ZIPUtil getInstance() {
        return instance;
    }

    @Override
    public synchronized void zip(String inputFilename, String zipFilename) throws IOException {
        this.zip(new File(inputFilename), zipFilename);
    }

    private synchronized void zip(File inputFile, String zipFilename) throws IOException {
        ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilename));
        try {
            this.zip(inputFile, out, "");
        }
        finally {
            out.close();
        }
    }

    private synchronized void zip(File inputFile, ZipOutputStream out, String base) throws IOException {
        if (inputFile.isDirectory()) {
            File[] inputFiles = inputFile.listFiles();
            base = base.length() == 0 ? "" : String.valueOf(base) + "/";
            int i = 0;
            while (i < inputFiles.length) {
                this.zip(inputFiles[i], out, String.valueOf(base) + inputFiles[i].getName());
                ++i;
            }
        } else {
            if (base.length() > 0) {
                out.putNextEntry(new ZipEntry(base));
            } else {
                out.putNextEntry(new ZipEntry(inputFile.getName()));
            }
            FileInputStream in = new FileInputStream(inputFile);
            try {
                int c;
                byte[] by = new byte[1024];
                while ((c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                }
            }
            finally {
                in.close();
            }
        }
    }

    @Override
    public synchronized void unzip(String zipFilename, String outputDirectory) throws IOException {
        File outFile = new File(outputDirectory);
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zipFilename);
        Enumeration en = zipFile.getEntries();
        ZipEntry zipEntry = null;
        while (en.hasMoreElements()) {
            File f;
            zipEntry = (ZipEntry)en.nextElement();
            if (zipEntry.isDirectory()) {
                String dirName = zipEntry.getName();
                dirName = dirName.substring(0, dirName.length() - 1);
                f = new File(String.valueOf(outFile.getPath()) + File.separator + dirName);
                f.mkdirs();
                continue;
            }
            String strFilePath = String.valueOf(outFile.getPath()) + File.separator + zipEntry.getName();
            f = new File(strFilePath);
            if (!f.exists()) {
                String[] arrFolderName = zipEntry.getName().split("/");
                String strRealFolder = "";
                int i = 0;
                while (i < arrFolderName.length - 1) {
                    strRealFolder = String.valueOf(strRealFolder) + arrFolderName[i] + File.separator;
                    ++i;
                }
                strRealFolder = String.valueOf(outFile.getPath()) + File.separator + strRealFolder;
                File tempDir = new File(strRealFolder);
                tempDir.mkdirs();
            }
            f.createNewFile();
            InputStream in = zipFile.getInputStream(zipEntry);
            FileOutputStream out = new FileOutputStream(f);
            try {
                int c;
                byte[] by = new byte[1024];
                while ((c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        zipFile.close();
    }

    public synchronized void unzip_noFolder(String zipFilename, String outputDirectory) throws IOException {
        File outFile = new File(outputDirectory);
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zipFilename);
        Enumeration en = zipFile.getEntries();
        ZipEntry zipEntry = null;
        while (en.hasMoreElements()) {
            zipEntry = (ZipEntry)en.nextElement();
            if (zipEntry.isDirectory()) {
                String dirName = zipEntry.getName();
                dirName = dirName.substring(dirName.lastIndexOf("/") + 1, dirName.length());
                File f = new File(String.valueOf(outFile.getPath()) + File.separator + dirName);
                f.mkdirs();
                continue;
            }
            String zname = zipEntry.getName();
            zname = zname.substring(zname.lastIndexOf("/") + 1, zname.length());
            String strFilePath = String.valueOf(outFile.getPath()) + File.separator + zname;
            File f = new File(strFilePath);
            InputStream in = zipFile.getInputStream(zipEntry);
            FileOutputStream out = new FileOutputStream(f);
            try {
                int c;
                byte[] by = new byte[1024];
                while ((c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        zipFile.close();
    }

    public synchronized Boolean deleteFiles(String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            System.out.println("z\u76f4\u63a5\u5220\u9664::" + path);
            return file.delete();
        }
        if (file.isDirectory()) {
            String[] filelist = file.list();
            int j = 0;
            while (j < filelist.length) {
                File filessFile = new File(String.valueOf(path) + "\\" + filelist[j]);
                if (!filessFile.isDirectory()) {
                    filessFile.delete();
                } else if (filessFile.isDirectory()) {
                    this.deleteFiles(String.valueOf(path) + "\\" + filelist[j]);
                }
                ++j;
            }
            System.out.println("d\u76f4\u63a5\u5220\u9664");
            return file.delete();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        ZIPUtil bean = new ZIPUtil();
    }
}

