/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.gwj.domain;

import com.unionpay.acp.gwj.exception.RuleValidateException;
import com.unionpay.acp.gwj.util.DateUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Rule {
    private boolean required = true;
    private int maxLength;
    private int minLength;
    private int length;
    private String equals;
    private String isDate;
    private int decimal;

    public void validate(String name, String label, String value, Map<String, Object> requestMap) {
        this.validateRequired(name, label, value);
        this.validateMaxLength(name, label, value);
        this.validateMinLength(name, label, value);
        this.validateLength(name, label, value);
        this.validateEquals(name, label, value, requestMap);
        this.validateIsDate(name, label, value);
        this.validateDecimal(name, label, value);
    }

    private void validateRequired(String name, String label, String value) {
        if (!this.required) {
            return;
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new RuleValidateException(name, "01", label + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateMaxLength(String name, String label, String value) {
        if (this.maxLength > 0 && value.length() > this.maxLength) {
            throw new RuleValidateException(name, "02", label + "\u8f93\u5165\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + this.maxLength);
        }
    }

    private void validateMinLength(String name, String label, String value) {
        if (this.minLength > 0 && value.length() < this.minLength) {
            throw new RuleValidateException(name, "03", label + "\u8f93\u5165\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + this.minLength);
        }
    }

    private void validateLength(String name, String label, String value) {
        if (this.length > 0 && value.length() != this.length) {
            throw new RuleValidateException(name, "04", label + "\u8f93\u5165\u957f\u5ea6\u987b\u7b49\u4e8e" + this.length);
        }
    }

    private void validateEquals(String name, String label, String value, Map<String, Object> contextMap) {
        String expectEqualItemName;
        String expectValue;
        if (!StringUtils.isEmpty((String)this.equals) && !value.equals(expectValue = (String)contextMap.get(expectEqualItemName = this.equals.substring("${".length(), this.equals.length() - 1)))) {
            throw new RuleValidateException(name, "05", label + "\u4e24\u6b21\u8f93\u5165\u7684\u503c\u4e0d\u76f8\u540c");
        }
    }

    private void validateIsDate(String name, String label, String value) {
        if (!StringUtils.isEmpty((String)this.isDate) && DateUtil.parseDate(value, this.isDate) == null) {
            throw new RuleValidateException(name, "06", label + "\u65f6\u95f4\u683c\u5f0f\u975e\u6cd5");
        }
    }

    private void validateDecimal(String name, String label, String value) {
        if (this.decimal > 0) {
            if (StringUtils.isEmpty((String)value)) {
                throw new RuleValidateException(name, "07", label + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal bd = new BigDecimal(value);
            if (bd.doubleValue() > 9.99999999999E9) {
                throw new RuleValidateException(name, "07", label + "\u7684\u503c\u975e\u6cd5");
            }
            int index = value.indexOf(46);
            if (index > 0 && value.length() - index > this.decimal + 1) {
                throw new RuleValidateException(name, "07", label + "\u4e0d\u80fd\u8d85\u8fc7" + this.decimal + "\u4f4d\u5c0f\u6570");
            }
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getEquals() {
        return this.equals;
    }

    public void setEquals(String equals) {
        this.equals = equals;
    }

    public String getIsDate() {
        return this.isDate;
    }

    public void setIsDate(String isDate) {
        this.isDate = isDate;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }
}

