/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.gwj.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_FMT_YMDHMSS = "yyyyMMddHHmmssSSS";
    public static final String DATE_FMT_YMD_HMSS = "yyyyMMdd HH:mm:ss";
    public static final String DATE_FMT_YMDHMS = "yyyyMMddHHmmss";
    public static final String DATE_FMT_Y_M_D = "yyyy-MM-dd";
    public static final String DATE_FMT_YMD = "yyyyMMdd";
    public static final String DATE_FMT_YM = "yyyyMM";
    public static final String DATE_FMT_HMS = "HHmmss";
    public static final String DATE_FMT_MD = "MMdd";
    public static final String DATE_FMT_HM = "HH:mm";

    public static String getDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getDate(Date date) {
        return DateUtil.getDate(date, DATE_FMT_YMD);
    }

    public static String getDateTime(Date date) {
        return DateUtil.getDate(date, DATE_FMT_YMDHMS);
    }

    public static String getHourMinuteOfTime(Date date) {
        return new SimpleDateFormat(DATE_FMT_HMS).format(date);
    }

    public static String getDayOfMonth(Date date) {
        return new SimpleDateFormat(DATE_FMT_MD).format(date);
    }

    public static Date addDate(Date date, int dayInterval) {
        return DateUtil.addDate(date, 5, dayInterval);
    }

    public static Date addMonth(Date date, int monthInterval) {
        return DateUtil.addDate(date, 2, monthInterval);
    }

    public static Date addDate(Date date, int field, int interval) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(field, interval);
        return c.getTime();
    }

    public static Date parseDate(String time) {
        return DateUtil.parseDate(time, DATE_FMT_Y_M_D);
    }

    public static Date parseDateTime(String time) {
        return DateUtil.parseDate(time, DATE_FMT_YMDHMS);
    }

    public static Date parseTime(String time) {
        return DateUtil.parseDate(time, DATE_FMT_HM);
    }

    public static Date parseDate(String time, String format) {
        try {
            SimpleDateFormat s = new SimpleDateFormat(format);
            s.setLenient(false);
            return s.parse(time);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValidDate(String date, String format) {
        SimpleDateFormat s = new SimpleDateFormat(format);
        try {
            s.setLenient(false);
            s.parse(date);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

