/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.gwj.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class JsonUtil {
    private static final Logger logger = Logger.getLogger(JsonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static <T> T fromJson(String json, Class<T> t) {
        if (json == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, t);
        }
        catch (Exception e) {
            logger.info((Object)("Cannot parse json string to Object. Json: <" + json + ">, Object class: <" + t.getName() + ">."), (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJsonWithException(String json, Class<T> t) {
        try {
            return (T)mapper.readValue(json, t);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromMap(Map<?, ?> map, Class<T> t) {
        if (map == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(JsonUtil.toJson(map), t);
        }
        catch (Exception e) {
            logger.info((Object)("Cannot parse map to Object. Map: <" + map + ">, Object class: <" + t.getName() + ">."), (Throwable)e);
            return null;
        }
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.warn((Object)e);
            return "{}";
        }
    }

    static {
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.getSerializationConfig().withDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT));
    }
}

