/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdksample.batch;

import com.unionpay.acp.sdk.HttpClient;
import com.unionpay.acp.sdk.LogUtil;
import com.unionpay.acp.sdk.SDKConfig;
import com.unionpay.acp.sdk.SDKUtil;
import com.unionpay.acp.sdk.SecureUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BatchTransExample {
    public static String FILENAME = "TH00000000700000000000001201407101000I.txt";
    public static String type;
    public static String acqInsCode;
    public static String merId;
    public static String txnTime;
    public static String batchNo;
    public static String totalQty;
    public static String totalAmt;

    public static void main(String[] args) {
        BatchTransExample.send();
    }

    public static void decode() {
    }

    public static void fieldUpload(Map<String, String> map, String fileName) {
        try {
            URL dd = BatchTransExample.class.getClassLoader().getResource(fileName);
            if (null == dd) {
                LogUtil.writeLog("\u627e\u4e0d\u5230\u6587\u4ef6" + fileName);
                return;
            }
            FileInputStream ins = new FileInputStream(dd.getFile());
            byte[] b = new byte[ins.available()];
            ins.read(b);
            ins.close();
            FileReader fr = new FileReader(dd.getFile());
            BufferedReader br = new BufferedReader(fr);
            String ss = br.readLine();
            br.close();
            String[] arr = ss.split("[|]");
            type = fileName.substring(0, 2);
            acqInsCode = fileName.substring(2, 10);
            merId = fileName.substring(10, 25);
            txnTime = fileName.substring(25, 33);
            batchNo = fileName.substring(33, 37);
            merId = arr[0];
            batchNo = arr[1];
            txnTime = arr[2];
            totalAmt = arr[3];
            totalQty = arr[4];
            String string = new String(b);
            string = new String(SecureUtil.base64Encode(SecureUtil.deflater(b)));
            map.put("fileContent", string);
            String txnSubType = null;
            if ("TH".equals(type)) {
                txnSubType = "01";
            } else if ("DK".equals(type)) {
                txnSubType = "02";
            } else if ("DF".equals(type)) {
                txnSubType = "03";
            }
            map.put("txnSubType", txnSubType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void send() {
        SDKConfig.getConfig().loadPropertiesFromSrc();
        String version = "5.0.0";
        String encoding = "UTF-8";
        String certId = "999999999999";
        String signMethod = "02";
        String txnType = "21";
        String bizType = "000000";
        String channelType = "08";
        String accessType = "1";
        String subMerId = "";
        String subMerName = "";
        String reqReserved = "";
        String reserved = "";
        HashMap<String, String> req = new HashMap<String, String>();
        BatchTransExample.fieldUpload(req, FILENAME);
        req.put("version", version);
        req.put("encoding", encoding);
        req.put("certId", certId);
        req.put("signMethod", signMethod);
        req.put("txnType", txnType);
        req.put("bizType", bizType);
        req.put("channelType", channelType);
        req.put("accessType", accessType);
        if (StringUtils.isNotBlank((String)acqInsCode)) {
            req.put("acqInsCode", acqInsCode);
        }
        if (StringUtils.isNotBlank((String)merId)) {
            req.put("merId", merId);
        }
        if (StringUtils.isNotBlank((String)subMerId)) {
            req.put("subMerId", subMerId);
        }
        if (StringUtils.isNotBlank((String)subMerName)) {
            req.put("subMerName", subMerName);
        }
        req.put("batchNo", batchNo);
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        req.put("txnTime", txnTime + sdf.format(new Date()));
        req.put("totalQty", totalQty);
        req.put("totalAmt", totalAmt);
        if (StringUtils.isNotBlank((String)reqReserved)) {
            req.put("reqReserved", reqReserved);
        }
        if (StringUtils.isNotBlank((String)reserved)) {
            req.put("reserved", reserved);
        }
        SDKUtil.sign(req, encoding);
        LogUtil.writeLog("BackRequest\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u8868\u5355\u5982\u4e0b");
        LogUtil.printRequestLog(req);
        String tradUrl = SDKConfig.getConfig().getBatchTransUrl();
        LogUtil.writeLog("\u53d1\u9001\u62a5\u6587\u5230\u540e\u53f0");
        LogUtil.writeLog("\u8bf7\u6c42\u5730\u5740tradUrl=[" + tradUrl + "]");
        String result = null;
        HttpClient hc = new HttpClient(tradUrl, 30000, 30000);
        try {
            int status = hc.send(req, encoding);
            if (200 == status) {
                result = hc.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u62a5\u6587\u53d1\u9001\u540e\u7684\u54cd\u5e94\u4fe1\u606f\uff1a  " + result);
    }
}

