/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.Base64Coder;
import com.upyun.UpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpYunUtils {
    public static final String VERSION = "upyun-java-sdk/4.2.2";
    private static final String SEPARATOR = "/";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String getPolicy(Map<String, Object> paramMap) {
        JSONObject obj = new JSONObject(paramMap);
        return Base64Coder.encodeString(obj.toString());
    }

    public static String getSignature(String policy, String secretKey) {
        return UpYunUtils.md5(policy + "&" + secretKey);
    }

    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is unsupported", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String md5(File file, int blockSize) {
        try {
            int length;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[blockSize];
            while ((length = in.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, length);
            }
            byte[] hash = messageDigest.digest();
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException("file get md5 failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
    }

    public static String md5(byte[] bytes) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String sign(String method, String date, String path, String userName, String password, String md5) throws UpException {
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append(method);
        sb.append(sp);
        sb.append(path);
        sb.append(sp);
        sb.append(date);
        if (md5 != null && md5.length() > 0) {
            sb.append(sp);
            sb.append(md5);
        }
        String raw = sb.toString().trim();
        byte[] hmac = null;
        try {
            hmac = UpYunUtils.calculateRFC2104HMACRaw(password, raw);
        }
        catch (Exception e) {
            throw new UpException("calculate SHA1 wrong.");
        }
        if (hmac != null) {
            return "UPYUN " + userName + ":" + Base64Coder.encodeLines(hmac).trim();
        }
        return null;
    }

    public static byte[] calculateRFC2104HMACRaw(String key, String data) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return mac.doFinal(data.getBytes());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String formatPath(String bucketName, String path) {
        if (!UpYunUtils.isEmpty(path) && !(path = path.trim()).startsWith(SEPARATOR)) {
            return SEPARATOR + bucketName + SEPARATOR + path;
        }
        return SEPARATOR + bucketName + path;
    }

    public static String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }
}

