/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.UpYun;
import com.upyun.UpException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;

public class FileBucketDemo {
    private static final String BUCKET_NAME = "\u7a7a\u95f4\u540d\u79f0";
    private static final String OPERATOR_NAME = "\u64cd\u4f5c\u5458\u540d\u79f0";
    private static final String OPERATOR_PWD = "\u64cd\u4f5c\u5458\u5bc6\u7801";
    private static final String DIR_ROOT = "/";
    private static final String DIR_MORE = "/1/2/3/";
    private static final String FOLDER_NAME = "tmp";
    private static final String FILE_NAME = "test.txt";
    private static final String SAMPLE_TXT_FILE = System.getProperty("user.dir") + "/test.txt";
    private static UpYun upyun = null;

    public static void main(String[] args) throws IOException, UpException {
        upyun = new UpYun(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        upyun.setDebug(true);
        FileBucketDemo.testMkDir();
        FileBucketDemo.testWriteFile();
        FileBucketDemo.testGetFileInfo();
        FileBucketDemo.testReadDir();
        FileBucketDemo.testGetBucketUsage();
        FileBucketDemo.testGetFolderUsage();
        FileBucketDemo.testReadFile();
        FileBucketDemo.testDeleteFile();
        FileBucketDemo.testRmDir();
        FileBucketDemo.testCopyFile();
        FileBucketDemo.testMoveFile();
    }

    public static void testGetBucketUsage() throws IOException, UpException {
        long usage = upyun.getBucketUsage();
        System.out.println("\u7a7a\u95f4\u603b\u4f7f\u7528\u91cf\uff1a" + usage + "B");
        System.out.println();
    }

    public static void testGetFolderUsage() throws IOException, UpException {
        String dirPath = DIR_ROOT;
        long usage = upyun.getFolderUsage(dirPath);
        System.out.println("'" + dirPath + "'\u76ee\u5f55\u5360\u7528\u91cf\uff1a " + usage + "B");
        System.out.println();
    }

    public static void testWriteFile() throws IOException, UpException {
        String content = "test content";
        String filePath = "/test.txt";
        String filePath2 = "/1/2/3/test.txt";
        boolean result1 = upyun.writeFile(filePath, content);
        System.out.println("1.\u4e0a\u4f20 " + filePath + FileBucketDemo.isSuccess(result1));
        boolean result2 = upyun.writeFile(filePath2, content, true);
        System.out.println("2.\u4e0a\u4f20 " + filePath2 + FileBucketDemo.isSuccess(result2));
        File file = new File(SAMPLE_TXT_FILE);
        boolean result3 = upyun.writeFile(filePath, file, true);
        System.out.println("3.\u4e0a\u4f20 " + filePath + FileBucketDemo.isSuccess(result3));
        File file4 = new File(SAMPLE_TXT_FILE);
        upyun.setContentMD5(UpYun.md5(file4));
        boolean result4 = upyun.writeFile(filePath, file4, true);
        System.out.println("4.\u4e0a\u4f20 " + filePath + FileBucketDemo.isSuccess(result4));
        System.out.println();
    }

    public static void testGetFileInfo() throws IOException, UpException {
        String filePath = "/test.txt";
        System.out.println(filePath + " \u7684\u6587\u4ef6\u4fe1\u606f\uff1a" + upyun.getFileInfo(filePath));
        System.out.println();
    }

    public static void testReadFile() throws IOException, UpException {
        String filePath = "/test.txt";
        String datas = upyun.readFile(filePath);
        System.out.println(filePath + " \u7684\u6587\u4ef6\u5185\u5bb9:" + datas);
        File file = File.createTempFile("upyunTempFile_", "");
        boolean result = upyun.readFile(filePath, file);
        System.out.println(filePath + " \u4e0b\u8f7d" + FileBucketDemo.isSuccess(result) + "\uff0c\u4fdd\u5b58\u5230 " + file.getAbsolutePath());
        System.out.println();
    }

    public static void testDeleteFile() throws IOException, UpException {
        String filePath = "/test.txt";
        boolean result = upyun.deleteFile(filePath, null);
        System.out.println(filePath + " \u5220\u9664" + FileBucketDemo.isSuccess(result));
        System.out.println();
    }

    public static void testMkDir() throws IOException, UpException {
        String dir1 = "/tmp";
        boolean result1 = upyun.mkDir(dir1);
        System.out.println("\u521b\u5efa\u76ee\u5f55\uff1a" + dir1 + FileBucketDemo.isSuccess(result1));
        String dir2 = "/1/2/3/tmp";
        boolean result2 = upyun.mkDir(dir2, true);
        System.out.println("\u81ea\u52a8\u521b\u5efa\u591a\u7ea7\u76ee\u5f55\uff1a" + dir2 + FileBucketDemo.isSuccess(result2));
        System.out.println();
    }

    public static void testReadDir() throws IOException, UpException {
        String dirPath = DIR_ROOT;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_LIST_LIMIT.getValue(), "10");
        UpYun.FolderItemIter folderItemIter = upyun.readDirIter(dirPath, params);
        System.out.println(folderItemIter);
        String json = upyun.readDirJson(dirPath, params);
        System.out.println(json);
        System.out.println();
    }

    public static void testRmDir() throws IOException, UpException {
        String dirPath = "/1/2/3/tmp";
        boolean result = upyun.rmDir(dirPath);
        System.out.println("\u5220\u9664\u76ee\u5f55\uff1a" + dirPath + FileBucketDemo.isSuccess(result));
        System.out.println();
    }

    public static void testCopyFile() throws IOException, UpException {
        String filePath = "/test.txt";
        boolean result = upyun.copyFile("/test.aa", "/\u7a7a\u95f4\u540d\u79f0" + filePath);
        Assert.assertTrue((boolean)result);
    }

    public static void testMoveFile() throws IOException, UpException {
        String filePath = "/test.txt";
        boolean result = upyun.moveFile("/test.aa", "/\u7a7a\u95f4\u540d\u79f0" + filePath);
        Assert.assertTrue((boolean)result);
    }

    private static String isSuccess(boolean result) {
        return result ? " \u6210\u529f" : " \u5931\u8d25";
    }

    static {
        File txtFile = new File(SAMPLE_TXT_FILE);
        if (!txtFile.isFile()) {
            System.out.println("\u672c\u5730\u5f85\u4e0a\u4f20\u7684\u6d4b\u8bd5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }
}

