/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

public class SpecExample {
    public static final SpecExample NULL = new SpecExample(null, "", 0, "", "");
    private final String optionsSet;
    private final String section;
    private final int exampleNumber;
    private final String source;
    private final String html;
    private final String ast;
    private final String comment;

    public SpecExample(String optionsSet, String section, int exampleNumber, String source, String html) {
        this(optionsSet, section, exampleNumber, source, html, null);
    }

    public SpecExample(String optionsSet, String section, int exampleNumber, String source, String html, String ast) {
        this(optionsSet, section, exampleNumber, source, html, null, null);
    }

    public SpecExample(String optionsSet, String section, int exampleNumber, String source, String html, String ast, String comment) {
        String trimmedSet;
        this.section = section;
        this.exampleNumber = exampleNumber;
        this.source = source;
        this.html = html;
        this.ast = ast;
        String string = this.comment = comment == null ? null : comment.trim();
        this.optionsSet = optionsSet == null ? null : ((trimmedSet = optionsSet.trim()).isEmpty() ? null : trimmedSet);
    }

    public SpecExample withOptionsSet(String optionsSet) {
        return new SpecExample(optionsSet, this.section, this.exampleNumber, this.source, this.html, this.ast, this.comment);
    }

    public SpecExample withSection(String section) {
        return new SpecExample(this.optionsSet, section, this.exampleNumber, this.source, this.html, this.ast, this.comment);
    }

    public SpecExample withExampleNumber(int exampleNumber) {
        return new SpecExample(this.optionsSet, this.section, exampleNumber, this.source, this.html, this.ast, this.comment);
    }

    public SpecExample withSource(String source) {
        return new SpecExample(this.optionsSet, this.section, this.exampleNumber, source, this.html, this.ast, this.comment);
    }

    public SpecExample withHtml(String html) {
        return new SpecExample(this.optionsSet, this.section, this.exampleNumber, this.source, html, this.ast, this.comment);
    }

    public SpecExample withAst(String ast) {
        return new SpecExample(this.optionsSet, this.section, this.exampleNumber, this.source, this.html, ast, this.comment);
    }

    public boolean isFullSpecExample() {
        return this == NULL;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isSpecExample() {
        return this != NULL;
    }

    public boolean isNotNull() {
        return this != NULL;
    }

    public String getOptionsSet() {
        return this.optionsSet;
    }

    public String getSource() {
        return this.source;
    }

    public String getHtml() {
        return this.html;
    }

    public String getAst() {
        return this.ast;
    }

    public String getSection() {
        return this.section;
    }

    public int getExampleNumber() {
        return this.exampleNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public String toString() {
        if (this == NULL) {
            return "Full Spec Test";
        }
        return "Section \"" + this.section + "\" example " + this.exampleNumber;
    }
}

