/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.abbvGapsHmm;

public final class Matrix3D {
    private final int M;
    private final int N;
    private final int K;
    private final double[][][] data;

    public Matrix3D(int M, int N, int K) {
        this.M = M;
        this.N = N;
        this.K = K;
        this.data = new double[M][N][K];
    }

    public Matrix3D(double[][][] data) {
        this.M = data.length;
        this.N = data[0].length;
        this.K = data[0][0].length;
        this.data = new double[this.M][this.N][this.K];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    this.data[i][j][l] = data[i][j][l];
                }
            }
        }
    }

    private Matrix3D(Matrix3D A) {
        this(A.data);
    }

    public static Matrix3D random(int M, int N, int K) {
        Matrix3D A = new Matrix3D(M, N, K);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int l = 0; l < K; ++l) {
                    A.data[i][j][l] = Math.random();
                }
            }
        }
        return A;
    }

    public static Matrix3D identity(int N) {
        Matrix3D I = new Matrix3D(N, N, N);
        for (int i = 0; i < N; ++i) {
            I.data[i][i][i] = 1.0;
        }
        return I;
    }

    public Matrix3D plus(Matrix3D B) {
        Matrix3D A = this;
        if (B.M != A.M || B.N != A.N || B.K != A.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix3D C = new Matrix3D(this.M, this.N, this.K);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    C.data[i][j][l] = A.data[i][j][l] + B.data[i][j][l];
                }
            }
        }
        return C;
    }

    public Matrix3D minus(Matrix3D B) {
        Matrix3D A = this;
        if (B.M != A.M || B.N != A.N || B.K != A.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix3D C = new Matrix3D(this.M, this.N, this.K);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    C.data[i][j][l] = A.data[i][j][l] - B.data[i][j][l];
                }
            }
        }
        return C;
    }

    public boolean eq(Matrix3D B) {
        Matrix3D A = this;
        if (B.M != A.M || B.N != A.N || B.K != A.K) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                for (int l = 0; l < this.K; ++l) {
                    if (A.data[i][j][l] == B.data[i][j][l]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Matrix3D times(double s) {
        Matrix3D A = this;
        Matrix3D C = new Matrix3D(A);
        for (int i = 0; i < C.M; ++i) {
            for (int j = 0; j < C.N; ++j) {
                int l = 0;
                while (l < C.K) {
                    double[] dArray = C.data[i][j];
                    int n = l++;
                    dArray[n] = dArray[n] * s;
                }
            }
        }
        return C;
    }

    public double at(int i, int j, int l) {
        return this.data[i][j][l];
    }

    public void set(int i, int j, int l, double val) {
        this.data[i][j][l] = val;
    }

    public void add(int i, int j, int l, double val) {
        double[] dArray = this.data[i][j];
        int n = l;
        dArray[n] = dArray[n] + val;
    }

    public void mul(int i, int j, int l, double val) {
        double[] dArray = this.data[i][j];
        int n = l;
        dArray[n] = dArray[n] * val;
    }

    public int dimension1() {
        return this.M;
    }

    public int dimension2() {
        return this.N;
    }

    public int dimension3() {
        return this.K;
    }
}

