/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeString;

public class TypeInt16
implements BreezeType<Short> {
    TypeInt16() {
    }

    public static short readInt16(BreezeBuffer buffer) {
        return buffer.getShort();
    }

    @Override
    public byte getType() {
        return -98;
    }

    @Override
    public Short read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return TypeInt16.readInt16(buffer);
        }
        byte type = buffer.get();
        switch (type) {
            case -98: {
                return TypeInt16.readInt16(buffer);
            }
            case 127: {
                return (short)TypeInt32.readInt32(buffer);
            }
            case 63: {
                return Short.parseShort(TypeString.readString(buffer));
            }
            case -104: {
                return (short)TypeInt64.readInt64(buffer);
            }
        }
        throw new BreezeException("Breeze cannot convert to Short. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, Short value, boolean withType) throws BreezeException {
        if (withType) {
            buffer.put((byte)-98);
        }
        buffer.putShort(value);
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Short field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null) {
            if (checkDefault && field == 0) {
                return;
            }
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

