/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypePackedMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class TypeMap
implements BreezeType<Map<?, ?>> {
    private Type kType;
    private Type vType;

    public TypeMap() {
        this.kType = Object.class;
        this.vType = Object.class;
    }

    public TypeMap(Type kType, Type vType) throws BreezeException {
        if (kType == null || vType == null) {
            throw new BreezeException("key type add value type must not null in TypeMap");
        }
        this.kType = kType;
        this.vType = vType;
    }

    public static int calculateInitSize(int size) throws BreezeException {
        if (size <= 10) {
            return 16;
        }
        if (size > Breeze.MAX_ELEM_SIZE) {
            throw new BreezeException("breeze map size over limit. size" + size);
        }
        return (int)((double)size / 0.75) + 1;
    }

    @Override
    public byte getType() {
        return -39;
    }

    @Override
    public Map read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        return this.read(buffer, null, this.kType, this.vType, withType);
    }

    public <T, K> Map<T, K> read(BreezeBuffer buffer, Map<T, K> map, Type kType, Type vType, boolean withType) throws BreezeException {
        if (withType) {
            byte type = buffer.get();
            if (type == -103) {
                return null;
            }
            if (type == -37) {
                return new TypePackedMap().read(buffer, map, kType, vType, false);
            }
            if (type != -39) {
                throw new BreezeException("unsupported by TypeMap. type:" + type);
            }
        }
        int size = (int)buffer.getVarint();
        if (map == null) {
            map = new HashMap<T, K>(TypeMap.calculateInitSize(size));
        }
        if (size == 0) {
            return map;
        }
        for (int i = 0; i < size; ++i) {
            map.put(BreezeReader.readObjectByType(buffer, kType), BreezeReader.readObjectByType(buffer, vType));
        }
        return map;
    }

    @Override
    public void write(BreezeBuffer buffer, Map<?, ?> value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            buffer.put((byte)-39);
        }
        int size = value.size();
        buffer.putVarint(size);
        if (size == 0) {
            return;
        }
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            BreezeWriter.writeObject(buffer, entry.getKey());
            BreezeWriter.writeObject(buffer, entry.getValue());
        }
    }
}

