/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.message;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypePackedArray;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schema {
    private final Map<String, Field> fieldNameMap = new HashMap<String, Field>();
    private final Map<Integer, Field> fieldIndexMap = new HashMap<Integer, Field>(0);
    private final Map<Integer, String> enumValues = new HashMap<Integer, String>(0);
    private final Map<String, Integer> enumNameMap = new HashMap<String, Integer>(0);
    private String name;
    private String alias;
    private String javaName;
    private boolean primitive = true;
    private boolean isEnum;

    public static Schema newSchema(String name) {
        return new Schema().setName(name);
    }

    public Schema putField(int index, String name) throws BreezeException {
        return this.putField(index, name, null);
    }

    public Schema putField(int index, String name, String type) throws BreezeException {
        return this.putField(new Field(index, name, type));
    }

    public Schema putField(Field field) throws BreezeException {
        if (field != null) {
            Field old = this.fieldNameMap.put(field.getName(), field);
            if (old != null) {
                throw new BreezeException("field name is same. schema: " + this.name + " field name:" + field.getName());
            }
            old = this.fieldIndexMap.put(field.getIndex(), field);
            if (old != null) {
                throw new BreezeException("field index is same. schema: " + this.name + ", index: " + field.getIndex() + ", field name:" + field.getName());
            }
        }
        return this;
    }

    public Field getFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    public Field getFieldByIndex(int index) {
        return this.fieldIndexMap.get(index);
    }

    public Map<Integer, Field> getFields() {
        return this.fieldIndexMap;
    }

    public String getName() {
        return this.name;
    }

    public Schema setName(String name) {
        this.name = name;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public Schema setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public Schema setPrimitive(boolean primitive) {
        this.primitive = primitive;
        return this;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean anEnum) {
        this.isEnum = anEnum;
    }

    public Map<Integer, String> getEnumValues() {
        return this.enumValues;
    }

    public Integer getEnumNumber(String name) {
        return this.enumNameMap.get(name);
    }

    public Schema addEnumValue(Integer number, String value) {
        this.enumValues.put(number, value);
        this.enumNameMap.put(value, number);
        return this;
    }

    public static class Field {
        private int index;
        private String name;
        private String type;
        private volatile BreezeType breezeType;
        private java.lang.reflect.Field field;
        private volatile boolean checked;
        private boolean checkDefault;

        public Field(int index, String name, String type) throws BreezeException {
            this(index, name, type, null);
        }

        public Field(int index, String name, String type, java.lang.reflect.Field field) throws BreezeException {
            if (index < 1) {
                throw new BreezeException("schema field index should great than 0");
            }
            if (field != null) {
                field.setAccessible(true);
                this.breezeType = Breeze.getBreezeType(field.getGenericType());
                this.setCheckDefaultByType(field.getGenericType());
            }
            if (name == null) {
                throw new BreezeException("schema field name must not null");
            }
            this.index = index;
            this.name = name.trim();
            this.type = type;
            this.field = field;
        }

        public String getDesc() {
            return "Field{index=" + this.index + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public BreezeType getBreezeType() {
            return this.breezeType;
        }

        public void setBreezeType(BreezeType breezeType) {
            this.breezeType = breezeType;
        }

        public Object getFieldInstance(Object object) throws IllegalAccessException, BreezeException {
            this.checkField();
            return this.field.get(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeField(BreezeBuffer buffer, Object object) throws BreezeException {
            block15: {
                this.checkField();
                try {
                    Object fieldObject = this.field.get(object);
                    if (fieldObject == null) break block15;
                    if (this.breezeType == null && !this.checked) {
                        Field field = this;
                        synchronized (field) {
                            if (this.breezeType == null && !this.checked) {
                                this.breezeType = Breeze.getBreezeType(this.field.getGenericType());
                                this.setCheckDefaultByType(this.field.getGenericType());
                                this.checked = true;
                            }
                        }
                    }
                    if (this.breezeType != null) {
                        if (this.breezeType instanceof TypePackedArray && this.field.getType().isArray()) {
                            buffer.putVarint(this.index);
                            if (this.field.getType().getComponentType().isPrimitive()) {
                                Object[] tempObjects = new Object[Array.getLength(fieldObject)];
                                for (int i = 0; i < tempObjects.length; ++i) {
                                    tempObjects[i] = Array.get(fieldObject, i);
                                }
                                ((TypePackedArray)this.breezeType).writeArray(buffer, tempObjects, true);
                            } else {
                                ((TypePackedArray)this.breezeType).writeArray(buffer, (Object[])fieldObject, true);
                            }
                        } else {
                            this.breezeType.writeMessageField(buffer, this.index, fieldObject, true, this.checkDefault);
                        }
                    } else if (object != null) {
                        buffer.putVarint(this.index);
                        BreezeWriter.writeObject(buffer, fieldObject);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new BreezeException("can not get field. class:" + this.field.getDeclaringClass() + ", field: " + this.name + ". e:" + e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readField(BreezeBuffer buffer, Object object) throws BreezeException {
            this.checkField();
            try {
                Object fieldObject;
                if (this.breezeType == null && !this.checked) {
                    Field field = this;
                    synchronized (field) {
                        if (this.breezeType == null && !this.checked) {
                            this.breezeType = Breeze.getBreezeType(this.field.getGenericType());
                            this.setCheckDefaultByType(this.field.getGenericType());
                            this.checked = true;
                        }
                    }
                }
                if (this.breezeType != null) {
                    if (this.breezeType instanceof TypePackedArray && this.field.getType().isArray()) {
                        List tempList = (List)((TypePackedArray)this.breezeType).read(buffer);
                        fieldObject = Array.newInstance(this.field.getType().getComponentType(), tempList.size());
                        for (int i = 0; i < tempList.size(); ++i) {
                            Array.set(fieldObject, i, tempList.get(i));
                        }
                    } else {
                        fieldObject = this.breezeType.read(buffer);
                    }
                } else {
                    fieldObject = BreezeReader.readObjectByType(buffer, this.field.getGenericType());
                }
                this.field.set(object, fieldObject);
            }
            catch (IllegalAccessException e) {
                throw new BreezeException("can not set field. class:" + this.field.getDeclaringClass() + ", field: " + this.name + ". e:" + e.getMessage());
            }
        }

        public Class<?> getFieldClass() throws BreezeException {
            this.checkField();
            return this.field.getType();
        }

        public Type getGenericType() throws BreezeException {
            this.checkField();
            return this.field.getGenericType();
        }

        public java.lang.reflect.Field getField() throws BreezeException {
            this.checkField();
            return this.field;
        }

        public void setField(java.lang.reflect.Field field) throws BreezeException {
            if (field != null) {
                field.setAccessible(true);
                Type type = field.getGenericType();
                this.breezeType = Breeze.getBreezeType(type);
                this.setCheckDefaultByType(type);
                if (this.breezeType != null && this.breezeType.getType() == -36) {
                    if (type instanceof ParameterizedType) {
                        type = ((ParameterizedType)type).getRawType();
                    }
                    if (type instanceof Class && !((Class)type).isAssignableFrom(List.class)) {
                        this.breezeType = null;
                        this.checked = true;
                    }
                }
            }
            this.field = field;
        }

        private void setCheckDefaultByType(Type fieldType) {
            Class clz;
            if (fieldType instanceof Class) {
                clz = (Class)fieldType;
            } else if (fieldType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)fieldType;
                clz = (Class)pt.getRawType();
            } else {
                return;
            }
            if (clz == Short.TYPE || clz == Integer.TYPE || clz == Long.TYPE || clz == Float.TYPE || clz == Double.TYPE || clz == Boolean.TYPE) {
                this.checkDefault = true;
            }
        }

        public boolean isCheckDefault() {
            return this.checkDefault;
        }

        public void setCheckDefault(boolean checkDefault) {
            this.checkDefault = checkDefault;
        }

        private void checkField() throws BreezeException {
            if (this.field == null) {
                throw new BreezeException("breeze schema field is null. " + this.getDesc());
            }
        }
    }
}

