/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class TypePackedMap
implements BreezeType<Map<?, ?>> {
    private volatile BreezeType keyType;
    private volatile BreezeType valueType;
    private Type kType;
    private Type vType;

    public TypePackedMap() {
    }

    public TypePackedMap(Type kType, Type vType) throws BreezeException {
        if (kType == null || vType == null) {
            throw new BreezeException("key type add value type must not null in TypePackedMap");
        }
        this.kType = kType;
        this.vType = vType;
        this.keyType = Breeze.getBreezeType(kType);
        this.valueType = Breeze.getBreezeType(vType);
        if (this.keyType == null || this.valueType == null) {
            throw new BreezeException("key type add value type must not null in TypePackedMap");
        }
    }

    @Override
    public byte getType() {
        return -37;
    }

    @Override
    public Map<?, ?> read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        return this.read(buffer, null, this.kType, this.vType, withType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, K> Map<T, K> read(BreezeBuffer buffer, Map<T, K> map, Type kType, Type vType, boolean withType) throws BreezeException {
        int type = -37;
        if (withType) {
            type = buffer.get();
            if (type == -103) {
                return null;
            }
            if (type != -37 && type != -39) {
                throw new BreezeException("unsupported by TypePackedMap. type:" + type);
            }
        }
        int size = (int)buffer.getVarint();
        if (map == null) {
            map = new HashMap<T, K>(TypeMap.calculateInitSize(size));
        }
        if (size == 0) {
            return map;
        }
        if (type == -37) {
            if (this.keyType == null) {
                TypePackedMap typePackedMap = this;
                synchronized (typePackedMap) {
                    if (this.keyType == null) {
                        this.keyType = BreezeReader.readBreezeType(buffer, kType);
                        this.valueType = BreezeReader.readBreezeType(buffer, vType);
                    } else {
                        BreezeReader.skipType(buffer);
                        BreezeReader.skipType(buffer);
                    }
                }
            } else {
                BreezeReader.skipType(buffer);
                BreezeReader.skipType(buffer);
            }
            for (int i = 0; i < size; ++i) {
                map.put(this.keyType.read(buffer, false), this.valueType.read(buffer, false));
            }
        } else if (this.keyType != null) {
            for (int i = 0; i < size; ++i) {
                map.put(this.keyType.read(buffer), this.valueType.read(buffer));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                map.put(BreezeReader.readObjectByType(buffer, kType), BreezeReader.readObjectByType(buffer, vType));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BreezeBuffer buffer, Map<?, ?> value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            buffer.put((byte)-37);
        }
        int size = value.size();
        buffer.putVarint(size);
        if (size == 0) {
            return;
        }
        if (this.keyType != null) {
            this.keyType.putType(buffer);
            this.valueType.putType(buffer);
        }
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new BreezeException("not support null value in breeze packed map. key:" + entry.getKey() + ", value:" + entry.getValue());
            }
            if (this.keyType == null) {
                TypePackedMap typePackedMap = this;
                synchronized (typePackedMap) {
                    if (this.keyType == null) {
                        this.keyType = Breeze.getBreezeTypeByObject(entry.getKey());
                        this.valueType = Breeze.getBreezeTypeByObject(entry.getValue());
                    }
                }
                this.keyType.putType(buffer);
                this.valueType.putType(buffer);
            }
            this.keyType.write(buffer, entry.getKey(), false);
            this.valueType.write(buffer, entry.getValue(), false);
        }
    }
}

