/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.AbstractReferer;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Future;
import com.weibo.api.motan.rpc.FutureListener;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Client;
import com.weibo.api.motan.transport.EndpointFactory;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.api.motan.transport.ProviderProtectedMessageRouter;
import com.weibo.api.motan.transport.Server;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.HashMap;
import java.util.Map;

@SpiMeta(name="motan")
public class DefaultRpcProtocol
extends AbstractProtocol {
    private Map<String, ProviderMessageRouter> ipPort2RequestRouter = new HashMap<String, ProviderMessageRouter>();

    @Override
    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        return new DefaultRpcExporter<T>(provider, url);
    }

    @Override
    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        return new DefaultRpcReferer<T>(clz, url, serviceUrl);
    }

    class DefaultRpcReferer<T>
    extends AbstractReferer<T> {
        private Client client;
        private EndpointFactory endpointFactory;

        public DefaultRpcReferer(Class<T> clz, URL url, URL serviceUrl) {
            super(clz, url, serviceUrl);
            this.endpointFactory = ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
            this.client = this.endpointFactory.createClient(url);
        }

        @Override
        protected Response doCall(Request request) {
            try {
                request.setAttachment(URLParamType.group.getName(), this.serviceUrl.getGroup());
                return this.client.request(request);
            }
            catch (TransportException exception) {
                throw new MotanServiceException("DefaultRpcReferer call Error: url=" + this.url.getUri(), exception);
            }
        }

        @Override
        protected void decrActiveCount(Request request, Response response) {
            if (response == null || !(response instanceof Future)) {
                this.activeRefererCount.decrementAndGet();
                return;
            }
            Future future = (Future)((Object)response);
            future.addListener(new FutureListener(){

                @Override
                public void operationComplete(Future future) throws Exception {
                    DefaultRpcReferer.this.activeRefererCount.decrementAndGet();
                }
            });
        }

        @Override
        protected boolean doInit() {
            boolean result = this.client.open();
            return result;
        }

        @Override
        public boolean isAvailable() {
            return this.client.isAvailable();
        }

        @Override
        public void destroy() {
            this.endpointFactory.safeReleaseResource(this.client, this.url);
            LoggerUtil.info("DefaultRpcReferer destory client: url={}" + this.url);
        }
    }

    class DefaultRpcExporter<T>
    extends AbstractExporter<T> {
        private Server server;
        private EndpointFactory endpointFactory;

        public DefaultRpcExporter(Provider<T> provider, URL url) {
            super(provider, url);
            ProviderMessageRouter requestRouter = this.initRequestRouter(url);
            this.endpointFactory = ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
            this.server = this.endpointFactory.createServer(url, requestRouter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unexport() {
            String protocolKey = MotanFrameworkUtil.getProtocolKey(this.url);
            String ipPort = this.url.getServerPortStr();
            Exporter exporter = (Exporter)DefaultRpcProtocol.this.exporterMap.remove(protocolKey);
            if (exporter != null) {
                exporter.destroy();
            }
            Map map = DefaultRpcProtocol.this.ipPort2RequestRouter;
            synchronized (map) {
                ProviderMessageRouter requestRouter = (ProviderMessageRouter)DefaultRpcProtocol.this.ipPort2RequestRouter.get(ipPort);
                if (requestRouter != null) {
                    requestRouter.removeProvider(this.provider);
                }
            }
            LoggerUtil.info("DefaultRpcExporter unexport Success: url={}", this.url);
        }

        @Override
        protected boolean doInit() {
            boolean result = this.server.open();
            return result;
        }

        @Override
        public boolean isAvailable() {
            return this.server.isAvailable();
        }

        @Override
        public void destroy() {
            this.endpointFactory.safeReleaseResource(this.server, this.url);
            LoggerUtil.info("DefaultRpcExporter destory Success: url={}", this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProviderMessageRouter initRequestRouter(URL url) {
            ProviderMessageRouter requestRouter = null;
            String ipPort = url.getServerPortStr();
            Map map = DefaultRpcProtocol.this.ipPort2RequestRouter;
            synchronized (map) {
                requestRouter = (ProviderMessageRouter)DefaultRpcProtocol.this.ipPort2RequestRouter.get(ipPort);
                if (requestRouter == null) {
                    requestRouter = new ProviderProtectedMessageRouter(this.provider);
                    DefaultRpcProtocol.this.ipPort2RequestRouter.put(ipPort, requestRouter);
                } else {
                    requestRouter.addProvider(this.provider);
                }
            }
            return requestRouter;
        }
    }
}

