/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import java.util.ArrayList;
import java.util.List;

public class ByteUtil {
    public static List<Byte> toList(byte[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Byte> list = new ArrayList<Byte>(array.length);
        for (byte value : array) {
            list.add(value);
        }
        return list;
    }

    public static byte[] toArray(List<Byte> list) {
        if (list == null) {
            return null;
        }
        byte[] array = new byte[list.size()];
        int index = 0;
        for (byte value : list) {
            array[index++] = value;
        }
        return array;
    }

    public static void long2bytes(long value, byte[] bytes, int off) {
        bytes[off + 7] = (byte)value;
        bytes[off + 6] = (byte)(value >>> 8);
        bytes[off + 5] = (byte)(value >>> 16);
        bytes[off + 4] = (byte)(value >>> 24);
        bytes[off + 3] = (byte)(value >>> 32);
        bytes[off + 2] = (byte)(value >>> 40);
        bytes[off + 1] = (byte)(value >>> 48);
        bytes[off] = (byte)(value >>> 56);
    }

    public static long bytes2long(byte[] bytes, int off) {
        return ((long)bytes[off + 7] & 0xFFL) + (((long)bytes[off + 6] & 0xFFL) << 8) + (((long)bytes[off + 5] & 0xFFL) << 16) + (((long)bytes[off + 4] & 0xFFL) << 24) + (((long)bytes[off + 3] & 0xFFL) << 32) + (((long)bytes[off + 2] & 0xFFL) << 40) + (((long)bytes[off + 1] & 0xFFL) << 48) + ((long)bytes[off] << 56);
    }

    public static void int2bytes(int value, byte[] bytes, int off) {
        bytes[off + 3] = (byte)value;
        bytes[off + 2] = (byte)(value >>> 8);
        bytes[off + 1] = (byte)(value >>> 16);
        bytes[off] = (byte)(value >>> 24);
    }

    public static int bytes2int(byte[] bytes, int off) {
        return (bytes[off + 3] & 0xFF) + ((bytes[off + 2] & 0xFF) << 8) + ((bytes[off + 1] & 0xFF) << 16) + (bytes[off] << 24);
    }

    public static void short2bytes(short value, byte[] bytes, int off) {
        bytes[off + 1] = (byte)value;
        bytes[off] = (byte)(value >>> 8);
    }

    public static short bytes2short(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + ((b[off] & 0xFF) << 8));
    }
}

