/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProvider<T>
implements Provider<T> {
    protected Class<T> clz;
    protected URL url;
    protected boolean alive = false;
    protected boolean close = false;
    protected Map<String, Method> methodMap = new HashMap<String, Method>();

    public AbstractProvider(URL url, Class<T> clz) {
        this.url = url;
        this.clz = clz;
        this.initMethodMap(clz);
    }

    @Override
    public Response call(Request request) {
        Response response = this.invoke(request);
        return response;
    }

    protected abstract Response invoke(Request var1);

    @Override
    public void init() {
        this.alive = true;
    }

    @Override
    public void destroy() {
        this.alive = false;
        this.close = true;
    }

    @Override
    public boolean isAvailable() {
        return this.alive;
    }

    @Override
    public String desc() {
        if (this.url != null) {
            return this.url.toString();
        }
        return null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Class<T> getInterface() {
        return this.clz;
    }

    protected Method lookup(Request request) {
        String methodDesc = ReflectUtil.getMethodDesc(request.getMethodName(), request.getParamtersDesc());
        return this.methodMap.get(methodDesc);
    }

    private void initMethodMap(Class<T> clz) {
        Method[] methods;
        for (Method method : methods = clz.getMethods()) {
            String methodDesc = ReflectUtil.getMethodDesc(method);
            this.methodMap.put(methodDesc, method);
        }
    }
}

