/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import java.nio.ByteBuffer;

public class GrowableByteBuffer {
    private ByteBuffer buf;

    public GrowableByteBuffer(int initSize) {
        this.buf = ByteBuffer.allocate(initSize);
    }

    public void put(byte b) {
        if (this.buf.remaining() < 1) {
            this.buf = this.grow(this.buf.capacity() * 2);
        }
        this.buf.put(b);
    }

    public void put(int index, byte b) {
        this.buf.put(index, b);
    }

    public void put(byte[] b) {
        if (this.buf.remaining() < b.length) {
            int size;
            for (size = this.buf.capacity() * 2; size < b.length + this.buf.position(); size *= 2) {
            }
            this.buf = this.grow(size);
        }
        this.buf.put(b);
    }

    public void putInt(int value) {
        if (this.buf.remaining() < 4) {
            this.buf = this.grow(this.buf.capacity() * 2);
        }
        this.buf.putInt(value);
    }

    public void putInt(int index, int value) {
        this.buf.putInt(index, value);
    }

    public void putLong(long value) {
        if (this.buf.remaining() < 8) {
            this.buf = this.grow(this.buf.capacity() * 2);
        }
        this.buf.putLong(value);
    }

    public void putLong(int index, long value) {
        this.buf.putLong(index, value);
    }

    public void flip() {
        this.buf.flip();
    }

    public int position() {
        return this.buf.position();
    }

    public void position(int newPosition) {
        this.buf.position(newPosition);
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public void get(byte[] dst) {
        this.buf.get(dst);
    }

    private ByteBuffer grow(int size) {
        ByteBuffer newbuf = ByteBuffer.allocate(size);
        newbuf.put(this.buf.array());
        newbuf.position(this.buf.position());
        return newbuf;
    }
}

