/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.util.LoggerUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    public static final String MOTAN_IP_PREFIX = "MOTAN_IP_PREFIX";
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.length() == 0 || host.equalsIgnoreCase("localhost") || host.equals(ANYHOST) || LOCAL_IP_PATTERN.matcher(host).matches();
    }

    public static boolean isValidLocalHost(String host) {
        return !NetUtils.isInvalidLocalHost(host);
    }

    public static InetAddress getLocalAddress() {
        return NetUtils.getLocalAddress(null);
    }

    public static InetAddress getLocalAddress(Map<String, Integer> destHostPorts) {
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        InetAddress localAddress = null;
        String ipPrefix = System.getenv(MOTAN_IP_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)ipPrefix)) {
            localAddress = NetUtils.getLocalAddressByNetworkInterface(ipPrefix);
            LoggerUtil.info("get local address by ip prefix: " + ipPrefix + ", address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressByHostname();
            LoggerUtil.info("get local address by hostname, address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressBySocket(destHostPorts);
            LoggerUtil.info("get local address by remote host. address:" + localAddress);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressByNetworkInterface(null);
            LoggerUtil.info("get local address from network interface. address:" + localAddress);
        }
        if (NetUtils.isValidAddress(localAddress)) {
            LOCAL_ADDRESS = localAddress;
        }
        return localAddress;
    }

    private static InetAddress getLocalAddressByHostname() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving local address by hostname:" + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InetAddress getLocalAddressBySocket(Map<String, Integer> destHostPorts) {
        if (destHostPorts == null) return null;
        if (destHostPorts.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<String, Integer>> iterator = destHostPorts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String host = entry.getKey();
            int port = entry.getValue();
            try {
                Socket socket = new Socket();
                try {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    socket.connect(addr, 1000);
                    LoggerUtil.info("get local address from socket. remote host:" + host + ", port:" + port);
                    InetAddress inetAddress = socket.getLocalAddress();
                    return inetAddress;
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("Failed to retriving local address by connecting to dest host:port(%s:%s) false, e=%s", host, port, e));
            }
        }
        return null;
    }

    private static InetAddress getLocalAddressByNetworkInterface(String prefix) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtils.isValidAddress(address)) continue;
                                if (StringUtils.isBlank((CharSequence)prefix)) {
                                    return address;
                                }
                                if (!address.getHostAddress().startsWith(prefix)) continue;
                                return address;
                            }
                            catch (Throwable e) {
                                logger.warn("Failed to retriving ip address, " + e.getMessage(), e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to retriving ip address, " + e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        return null;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getHostName(SocketAddress socketAddress) {
        InetAddress addr;
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress && (addr = ((InetSocketAddress)socketAddress).getAddress()) != null) {
            return addr.getHostAddress();
        }
        return null;
    }
}

