/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.support;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.HaStrategy;
import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.support.ProtocolFilterDecorator;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.registry.RegistryFactory;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ClusterSupport<T>
implements NotifyListener {
    private static ConcurrentHashMap<String, Protocol> protocols = new ConcurrentHashMap();
    private Cluster<T> cluster;
    private List<URL> registryUrls;
    private URL url;
    private Class<T> interfaceClass;
    private Protocol protocol;
    private ConcurrentHashMap<URL, List<Referer<T>>> registryReferers = new ConcurrentHashMap();

    public ClusterSupport(Class<T> interfaceClass, List<URL> registryUrls) {
        this.registryUrls = registryUrls;
        this.interfaceClass = interfaceClass;
        String urlStr = StringTools.urlDecode(registryUrls.get(0).getParameter(URLParamType.embed.getName()));
        this.url = URL.valueOf(urlStr);
        this.protocol = this.getDecorateProtocol(this.url.getProtocol());
    }

    public void init() {
        long start = System.currentTimeMillis();
        this.prepareCluster();
        URL subUrl = this.toSubscribeUrl(this.url);
        for (URL ru : this.registryUrls) {
            List<URL> directUrls;
            String directUrlStr = ru.getParameter(URLParamType.directUrl.getName());
            if (StringUtils.isNotBlank((CharSequence)directUrlStr) && !(directUrls = this.parseDirectUrls(directUrlStr)).isEmpty()) {
                this.notify(ru, directUrls);
                LoggerUtil.info("Use direct urls, refUrl={}, directUrls={}", this.url, directUrls);
                continue;
            }
            Registry registry = this.getRegistry(ru);
            registry.subscribe(subUrl, this);
        }
        boolean check = Boolean.parseBoolean(this.url.getParameter(URLParamType.check.getName(), URLParamType.check.getValue()));
        if (!CollectionUtil.isEmpty(this.cluster.getReferers()) || !check) {
            this.cluster.init();
            if (CollectionUtil.isEmpty(this.cluster.getReferers()) && !check) {
                LoggerUtil.warn(String.format("refer:%s", this.url.getPath() + "/" + this.url.getVersion()), "No services");
            }
            LoggerUtil.info("cluster init cost " + (System.currentTimeMillis() - start) + ", refer size:" + (this.cluster.getReferers() == null ? 0 : this.cluster.getReferers().size()) + ", cluster:" + this.cluster.getUrl().toSimpleString());
            return;
        }
        throw new MotanFrameworkException(String.format("ClusterSupport No service urls for the refer:%s, registries:%s", this.url.getIdentity(), this.registryUrls), MotanErrorMsgConstant.SERVICE_UNFOUND);
    }

    public void destroy() {
        URL subscribeUrl = this.toSubscribeUrl(this.url);
        for (URL ru : this.registryUrls) {
            try {
                Registry registry = this.getRegistry(ru);
                registry.unsubscribe(subscribeUrl, this);
                if ("referer".equals(this.url.getParameter(URLParamType.nodeType.getName()))) continue;
                registry.unregister(this.url);
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("Unregister or unsubscribe false for url (%s), registry= %s", this.url, ru.getIdentity()), e);
            }
        }
        try {
            this.getCluster().destroy();
        }
        catch (Exception e) {
            LoggerUtil.warn(String.format("Exception when destroy cluster: %s", this.getCluster().getUrl()));
        }
    }

    protected Registry getRegistry(URL url) {
        RegistryFactory registryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getExtension(url.getProtocol());
        return registryFactory.getRegistry(url);
    }

    private URL toSubscribeUrl(URL url) {
        URL subUrl = url.createCopy();
        subUrl.addParameter(URLParamType.nodeType.getName(), "service");
        return subUrl;
    }

    @Override
    public synchronized void notify(URL registryUrl, List<URL> urls) {
        if (CollectionUtil.isEmpty(urls)) {
            this.onRegistryEmpty(registryUrl);
            LoggerUtil.warn("ClusterSupport config change notify, urls is empty: registry={} service={} urls=[]", registryUrl.getUri(), this.url.getIdentity());
            return;
        }
        LoggerUtil.info("ClusterSupport config change notify: registry={} service={} urls={}", registryUrl.getUri(), this.url.getIdentity(), this.getIdentities(urls));
        this.processWeights(urls);
        ArrayList<Referer<T>> newReferers = new ArrayList<Referer<T>>();
        for (URL u : urls) {
            if (!u.canServe(this.url)) continue;
            Referer<T> referer = this.getExistingReferer(u, this.registryReferers.get(registryUrl));
            if (referer == null) {
                URL refererURL = u.createCopy();
                this.mergeClientConfigs(refererURL);
                referer = this.protocol.refer(this.interfaceClass, refererURL, u);
            }
            if (referer == null) continue;
            newReferers.add(referer);
        }
        if (CollectionUtil.isEmpty(newReferers)) {
            this.onRegistryEmpty(registryUrl);
            return;
        }
        this.registryReferers.put(registryUrl, newReferers);
        this.refreshCluster();
    }

    private void processWeights(List<URL> urls) {
        if (urls != null && !urls.isEmpty()) {
            URL ruleUrl = urls.get(0);
            String weights = URLParamType.weights.getValue();
            if ("rule".equalsIgnoreCase(ruleUrl.getProtocol())) {
                weights = ruleUrl.getParameter(URLParamType.weights.getName(), URLParamType.weights.getValue());
                urls.remove(0);
            }
            LoggerUtil.info("refresh weight. weight=" + weights);
            this.cluster.getLoadBalance().setWeightString(weights);
        }
    }

    private void onRegistryEmpty(URL excludeRegistryUrl) {
        boolean noMoreOtherRefers;
        boolean bl = noMoreOtherRefers = this.registryReferers.size() == 1 && this.registryReferers.containsKey(excludeRegistryUrl);
        if (noMoreOtherRefers) {
            LoggerUtil.warn(String.format("Ignore notify for no more referers in this cluster, registry: %s, cluster=%s", excludeRegistryUrl, this.getUrl()));
        } else {
            this.registryReferers.remove(excludeRegistryUrl);
            this.refreshCluster();
        }
    }

    protected Protocol getDecorateProtocol(String protocolName) {
        Protocol decorateProtocol = protocols.get(protocolName);
        if (decorateProtocol == null) {
            protocols.putIfAbsent(protocolName, new ProtocolFilterDecorator(ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(protocolName)));
            decorateProtocol = protocols.get(protocolName);
        }
        return decorateProtocol;
    }

    private Referer<T> getExistingReferer(URL url, List<Referer<T>> referers) {
        if (referers == null) {
            return null;
        }
        for (Referer<T> r : referers) {
            if (!ObjectUtils.equals((Object)url, (Object)r.getUrl()) && !ObjectUtils.equals((Object)url, (Object)r.getServiceUrl())) continue;
            return r;
        }
        return null;
    }

    private void mergeClientConfigs(URL refererURL) {
        String application = refererURL.getParameter(URLParamType.application.getName(), URLParamType.application.getValue());
        String module = refererURL.getParameter(URLParamType.module.getName(), URLParamType.module.getValue());
        refererURL.addParameters(this.url.getParameters());
        refererURL.addParameter(URLParamType.application.getName(), application);
        refererURL.addParameter(URLParamType.module.getName(), module);
    }

    private void refreshCluster() {
        ArrayList referers = new ArrayList();
        for (List<Referer<T>> refs : this.registryReferers.values()) {
            referers.addAll(refs);
        }
        this.cluster.onRefresh(referers);
    }

    public Cluster<T> getCluster() {
        return this.cluster;
    }

    public URL getUrl() {
        return this.url;
    }

    private String getIdentities(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (URL u : urls) {
            builder.append(u.getIdentity()).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    private void prepareCluster() {
        String clusterName = this.url.getParameter(URLParamType.cluster.getName(), URLParamType.cluster.getValue());
        String loadbalanceName = this.url.getParameter(URLParamType.loadbalance.getName(), URLParamType.loadbalance.getValue());
        String haStrategyName = this.url.getParameter(URLParamType.haStrategy.getName(), URLParamType.haStrategy.getValue());
        this.cluster = ExtensionLoader.getExtensionLoader(Cluster.class).getExtension(clusterName);
        LoadBalance loadBalance = ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(loadbalanceName);
        HaStrategy ha = ExtensionLoader.getExtensionLoader(HaStrategy.class).getExtension(haStrategyName);
        ha.setUrl(this.url);
        this.cluster.setLoadBalance(loadBalance);
        this.cluster.setHaStrategy(ha);
        this.cluster.setUrl(this.url);
    }

    private List<URL> parseDirectUrls(String directUrlStr) {
        String[] durlArr = MotanConstants.COMMA_SPLIT_PATTERN.split(directUrlStr);
        ArrayList<URL> directUrls = new ArrayList<URL>();
        for (String dus : durlArr) {
            URL du = URL.valueOf(StringTools.urlDecode(dus));
            if (du == null) continue;
            directUrls.add(du);
        }
        return directUrls;
    }
}

