/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.support;

import com.weibo.api.motan.closable.Closable;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Client;
import com.weibo.api.motan.transport.Endpoint;
import com.weibo.api.motan.transport.EndpointManager;
import com.weibo.api.motan.transport.HeartbeatFactory;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HeartbeatClientEndpointManager
implements EndpointManager {
    private ConcurrentMap<Client, HeartbeatFactory> endpoints = new ConcurrentHashMap<Client, HeartbeatFactory>();
    private ScheduledExecutorService executorService = null;

    @Override
    public void init() {
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : HeartbeatClientEndpointManager.this.endpoints.entrySet()) {
                    Client endpoint = (Client)entry.getKey();
                    try {
                        if (endpoint.isAvailable()) continue;
                        HeartbeatFactory factory = (HeartbeatFactory)entry.getValue();
                        endpoint.heartbeat(factory.createRequest());
                    }
                    catch (Exception e) {
                        LoggerUtil.error("HeartbeatEndpointManager send heartbeat Error: url=" + endpoint.getUrl().getUri() + ", " + e.getMessage());
                    }
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
        ShutDownHook.registerShutdownHook(new Closable(){

            @Override
            public void close() {
                if (!HeartbeatClientEndpointManager.this.executorService.isShutdown()) {
                    HeartbeatClientEndpointManager.this.executorService.shutdown();
                }
            }
        });
    }

    @Override
    public void destroy() {
        this.executorService.shutdownNow();
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof Client)) {
            throw new MotanFrameworkException("HeartbeatClientEndpointManager addEndpoint Error: class not support " + endpoint.getClass());
        }
        Client client = (Client)endpoint;
        URL url = endpoint.getUrl();
        String heartbeatFactoryName = url.getParameter(URLParamType.heartbeatFactory.getName(), URLParamType.heartbeatFactory.getValue());
        HeartbeatFactory heartbeatFactory = ExtensionLoader.getExtensionLoader(HeartbeatFactory.class).getExtension(heartbeatFactoryName);
        if (heartbeatFactory == null) {
            throw new MotanFrameworkException("HeartbeatFactory not exist: " + heartbeatFactoryName);
        }
        this.endpoints.put(client, heartbeatFactory);
    }

    @Override
    public void removeEndpoint(Endpoint endpoint) {
        this.endpoints.remove(endpoint);
    }

    public Set<Client> getClients() {
        return Collections.unmodifiableSet(this.endpoints.keySet());
    }
}

