/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support.command;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.command.CommandFailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.RpcCommand;
import com.weibo.api.motan.registry.support.command.RpcCommandUtil;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommandServiceManager
implements CommandListener,
ServiceListener {
    public static final String MOTAN_COMMAND_SWITCHER = "feature.motanrpc.command.enable";
    private static Pattern IP_PATTERN = Pattern.compile("^!?[0-9.]*\\*?$");
    private URL refUrl;
    private ConcurrentHashSet<NotifyListener> notifySet;
    private CommandFailbackRegistry registry;
    private Map<String, List<URL>> groupServiceCache;
    private String commandStringCache = "";
    private volatile RpcCommand commandCache;

    public CommandServiceManager(URL refUrl) {
        LoggerUtil.info("CommandServiceManager init url:" + refUrl.toFullStr());
        this.refUrl = refUrl;
        this.notifySet = new ConcurrentHashSet();
        this.groupServiceCache = new ConcurrentHashMap<String, List<URL>>();
    }

    @Override
    public void notifyService(URL serviceUrl, URL registryUrl, List<URL> urls) {
        if (this.registry == null) {
            throw new MotanFrameworkException("registry must be set.");
        }
        URL urlCopy = serviceUrl.createCopy();
        String groupName = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
        this.groupServiceCache.put(groupName, urls);
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (this.commandCache != null) {
            HashMap<String, Integer> weights = new HashMap<String, Integer>();
            finalResult = this.discoverServiceWithCommand(this.refUrl, weights, this.commandCache);
        } else {
            LoggerUtil.info("command cache is null. service:" + serviceUrl.toSimpleString());
            finalResult.addAll(this.discoverOneGroup(this.refUrl));
        }
        for (NotifyListener notifyListener : this.notifySet) {
            notifyListener.notify(this.registry.getUrl(), finalResult);
        }
    }

    @Override
    public void notifyCommand(URL serviceUrl, String commandString) {
        LoggerUtil.info("CommandServiceManager notify command. service:" + serviceUrl.toSimpleString() + ", command:" + commandString);
        if (!MotanSwitcherUtil.isOpen(MOTAN_COMMAND_SWITCHER) || commandString == null) {
            LoggerUtil.info("command reset empty since swither is close.");
            commandString = "";
        }
        ArrayList<URL> finalResult = new ArrayList<URL>();
        URL urlCopy = serviceUrl.createCopy();
        if (!StringUtils.equals((CharSequence)commandString, (CharSequence)this.commandStringCache)) {
            this.commandStringCache = commandString;
            this.commandCache = RpcCommandUtil.stringToCommand(this.commandStringCache);
            HashMap<String, Integer> weights = new HashMap<String, Integer>();
            if (this.commandCache != null && this.commandCache.getClientCommandList() != null && !this.commandCache.getClientCommandList().isEmpty()) {
                this.commandCache.sort();
                finalResult = this.discoverServiceWithCommand(this.refUrl, weights, this.commandCache);
            } else {
                if (StringUtils.isNotBlank((CharSequence)commandString)) {
                    LoggerUtil.warn("command parse fail, ignored! command:" + commandString);
                    commandString = "";
                }
                finalResult.addAll(this.discoverOneGroup(this.refUrl));
            }
            Set<String> groupKeys = this.groupServiceCache.keySet();
            for (String gk : groupKeys) {
                if (weights.containsKey(gk)) continue;
                this.groupServiceCache.remove(gk);
                URL urlTemp = urlCopy.createCopy();
                urlTemp.addParameter(URLParamType.group.getName(), gk);
                this.registry.unsubscribeService(urlTemp, this);
            }
            if ("".equals(commandString) || weights.isEmpty()) {
                LoggerUtil.info("reSub service" + this.refUrl.toSimpleString());
                this.registry.subscribeService(this.refUrl, this);
            }
        } else {
            LoggerUtil.info("command not change. url:" + serviceUrl.toSimpleString());
            return;
        }
        for (NotifyListener notifyListener : this.notifySet) {
            notifyListener.notify(this.registry.getUrl(), finalResult);
        }
    }

    public List<URL> discoverServiceWithCommand(URL serviceUrl, Map<String, Integer> weights, RpcCommand rpcCommand) {
        String localIP = NetUtils.getLocalAddress().getHostAddress();
        return this.discoverServiceWithCommand(serviceUrl, weights, rpcCommand, localIP);
    }

    public List<URL> discoverServiceWithCommand(URL serviceUrl, Map<String, Integer> weights, RpcCommand rpcCommand, String localIP) {
        if (rpcCommand == null || CollectionUtil.isEmpty(rpcCommand.getClientCommandList())) {
            return this.discoverOneGroup(serviceUrl);
        }
        LinkedList<URL> mergedResult = new LinkedList<URL>();
        String path = serviceUrl.getPath();
        List<RpcCommand.ClientCommand> clientCommandList = rpcCommand.getClientCommandList();
        boolean hit = false;
        for (RpcCommand.ClientCommand command : clientCommandList) {
            mergedResult = new LinkedList();
            boolean match = RpcCommandUtil.match(command.getPattern(), path);
            if (!match) continue;
            hit = true;
            if (!CollectionUtil.isEmpty(command.getMergeGroups())) {
                try {
                    this.buildWeightsMap(weights, command);
                }
                catch (MotanFrameworkException e) {
                    LoggerUtil.warn("build weights map fail!" + e.getMessage());
                    continue;
                }
                mergedResult.addAll(this.mergeResult(serviceUrl, weights));
            } else {
                mergedResult.addAll(this.discoverOneGroup(serviceUrl));
            }
            LoggerUtil.info("mergedResult: size-" + mergedResult.size() + " --- " + ((Object)mergedResult).toString());
            if (CollectionUtil.isEmpty(command.getRouteRules())) break;
            LoggerUtil.info("router: " + command.getRouteRules().toString());
            for (String routeRule : command.getRouteRules()) {
                int idx;
                String[] fromTo = routeRule.replaceAll("\\s+", "").split("to");
                if (fromTo.length != 2) {
                    this.routeRuleConfigError();
                    continue;
                }
                String from = fromTo[0];
                String to = fromTo[1];
                if (from.length() < 1 || to.length() < 1 || !IP_PATTERN.matcher(from).find() || !IP_PATTERN.matcher(to).find()) {
                    this.routeRuleConfigError();
                    continue;
                }
                boolean oppositeFrom = from.startsWith("!");
                boolean oppositeTo = to.startsWith("!");
                if (oppositeFrom) {
                    from = from.substring(1);
                }
                if (oppositeTo) {
                    to = to.substring(1);
                }
                boolean matchFrom = (idx = from.indexOf(42)) != -1 ? localIP.startsWith(from.substring(0, idx)) : localIP.equals(from);
                if (oppositeFrom) {
                    matchFrom = !matchFrom;
                }
                LoggerUtil.info("matchFrom: " + matchFrom + ", localip:" + localIP + ", from:" + from);
                if (!matchFrom) continue;
                Iterator iterator = mergedResult.iterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    if (url.getProtocol().equalsIgnoreCase("rule")) continue;
                    idx = to.indexOf(42);
                    boolean matchTo = idx != -1 ? url.getHost().startsWith(to.substring(0, idx)) : url.getHost().equals(to);
                    if (oppositeTo) {
                        boolean bl = matchTo = !matchTo;
                    }
                    if (matchTo) continue;
                    iterator.remove();
                    LoggerUtil.info("router To not match. url remove : " + url.toSimpleString());
                }
            }
        }
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (!hit) {
            finalResult = this.discoverOneGroup(serviceUrl);
        } else {
            finalResult.addAll(mergedResult);
        }
        return finalResult;
    }

    private void buildWeightsMap(Map<String, Integer> weights, RpcCommand.ClientCommand command) {
        for (String rule : command.getMergeGroups()) {
            String[] gw = rule.split(":");
            int weight = 1;
            if (gw.length > 1) {
                try {
                    weight = Integer.parseInt(gw[1]);
                }
                catch (NumberFormatException e) {
                    this.weightConfigError();
                }
                if (weight < 0 || weight > 100) {
                    this.weightConfigError();
                }
            }
            weights.put(gw[0], weight);
        }
    }

    private List<URL> mergeResult(URL url, Map<String, Integer> weights) {
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (weights.size() > 1) {
            URL ruleUrl = new URL("rule", url.getHost(), url.getPort(), url.getPath());
            StringBuilder weightsBuilder = new StringBuilder(64);
            for (Map.Entry<String, Integer> entry : weights.entrySet()) {
                weightsBuilder.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
            }
            ruleUrl.addParameter(URLParamType.weights.getName(), weightsBuilder.deleteCharAt(weightsBuilder.length() - 1).toString());
            finalResult.add(ruleUrl);
        }
        for (String key : weights.keySet()) {
            if (this.groupServiceCache.containsKey(key)) {
                finalResult.addAll((Collection<URL>)this.groupServiceCache.get(key));
                continue;
            }
            URL urlTemp = url.createCopy();
            urlTemp.addParameter(URLParamType.group.getName(), key);
            finalResult.addAll(this.discoverOneGroup(urlTemp));
            this.registry.subscribeService(urlTemp, this);
        }
        return finalResult;
    }

    private List<URL> discoverOneGroup(URL urlCopy) {
        LoggerUtil.info("CommandServiceManager discover one group. url:" + urlCopy.toSimpleString());
        String group = urlCopy.getParameter(URLParamType.group.getName(), URLParamType.group.getValue());
        List<URL> list = this.groupServiceCache.get(group);
        if (list == null) {
            list = this.registry.discoverService(urlCopy);
            this.groupServiceCache.put(group, list);
        }
        return list;
    }

    public void setCommandCache(String command) {
        this.commandStringCache = command;
        this.commandCache = RpcCommandUtil.stringToCommand(this.commandStringCache);
        LoggerUtil.info("CommandServiceManager set commandcache. commandstring:" + this.commandStringCache + ", comandcache " + (this.commandCache == null ? "is null." : "is not null."));
    }

    public void addNotifyListener(NotifyListener notifyListener) {
        this.notifySet.add(notifyListener);
    }

    public void removeNotifyListener(NotifyListener notifyListener) {
        this.notifySet.remove(notifyListener);
    }

    public void setRegistry(CommandFailbackRegistry registry) {
        this.registry = registry;
    }

    private void weightConfigError() {
        throw new MotanFrameworkException("\u6743\u91cd\u6bd4\u53ea\u80fd\u662f[0,100]\u95f4\u7684\u6574\u6570");
    }

    private void routeRuleConfigError() {
        LoggerUtil.warn("\u8def\u7531\u89c4\u5219\u914d\u7f6e\u4e0d\u5408\u6cd5");
    }

    static {
        MotanSwitcherUtil.initSwitcher(MOTAN_COMMAND_SWITCHER, true);
    }
}

