/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Callbackable;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.Traceable;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.StringTools;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="access")
@Activation(sequence=100, key={"service", "referer"})
public class AccessLogFilter
implements Filter {
    public static final String ACCESS_LOG_SWITCHER_NAME = "feature.motan.filter.accessLog";
    public static final String PRINT_TRACE_LOG_SWITCHER_NAME = "feature.motan.printTraceLog.enable";
    private String side;
    private Boolean accessLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response filter(Caller<?> caller, Request request) {
        if (this.accessLog == null) {
            this.accessLog = caller.getUrl().getBooleanParameter(URLParamType.accessLog.getName(), URLParamType.accessLog.getBooleanValue());
        }
        if (this.accessLog.booleanValue() || this.needLog(request)) {
            long start = System.currentTimeMillis();
            boolean success = false;
            Response response = null;
            try {
                response = caller.call(request);
                if (response != null && response.getException() == null) {
                    success = true;
                }
                Response response2 = response;
                return response2;
            }
            finally {
                this.processFinalLog(caller, request, response, start, success);
            }
        }
        return caller.call(request);
    }

    private void processFinalLog(Caller<?> caller, Request request, Response response, long start, boolean success) {
        long wholeTime;
        long segmentTime = wholeTime = System.currentTimeMillis() - start;
        if (request instanceof Traceable && response instanceof Traceable) {
            if (caller instanceof Provider) {
                if (response instanceof Callbackable) {
                    long finalSegmentTime = segmentTime;
                    ((Callbackable)((Object)response)).addFinishCallback(() -> {
                        long responseSend = ((Traceable)((Object)response)).getTraceableContext().getSendTime();
                        long requestReceive = ((Traceable)((Object)request)).getTraceableContext().getReceiveTime();
                        long finalWholeTime = responseSend - requestReceive;
                        this.logAccess(caller, request, response, finalSegmentTime, finalWholeTime, success);
                    }, null);
                    return;
                }
            } else {
                long requestSend = ((Traceable)((Object)request)).getTraceableContext().getSendTime();
                long responseReceive = ((Traceable)((Object)response)).getTraceableContext().getReceiveTime();
                segmentTime = responseReceive - requestSend;
            }
        }
        this.logAccess(caller, request, response, segmentTime, wholeTime, success);
    }

    private boolean needLog(Request request) {
        if (MotanSwitcherUtil.isOpen(ACCESS_LOG_SWITCHER_NAME)) {
            return true;
        }
        if (!MotanSwitcherUtil.isOpen(PRINT_TRACE_LOG_SWITCHER_NAME)) {
            return false;
        }
        return "true".equalsIgnoreCase(request.getAttachments().get("print_trace_log"));
    }

    private void logAccess(Caller<?> caller, Request request, Response response, long segmentTime, long wholeTime, boolean success) {
        if (this.getSide() == null) {
            String side = caller instanceof Provider ? "service" : "referer";
            this.setSide(side);
        }
        StringBuilder builder = new StringBuilder(128);
        this.append(builder, this.side);
        this.append(builder, caller.getUrl().getParameter(URLParamType.application.getName()));
        this.append(builder, MotanFrameworkUtil.getModuleOrGroup(caller.getUrl().getParameters(), null));
        this.append(builder, NetUtils.getLocalAddress().getHostAddress());
        this.append(builder, request.getInterfaceName());
        this.append(builder, request.getMethodName());
        this.append(builder, request.getParamtersDesc());
        if ("referer".equals(this.side)) {
            this.append(builder, caller.getUrl().getHost());
            this.append(builder, response == null ? null : response.getAttachments().get("x-forwarded-for"));
        } else {
            this.append(builder, request.getAttachments().get(URLParamType.host.getName()));
            this.append(builder, request.getAttachments().get("x-forwarded-for"));
        }
        this.append(builder, request.getAttachments().get(URLParamType.application.getName()));
        this.append(builder, MotanFrameworkUtil.getModuleOrGroup(request.getAttachments(), null));
        this.append(builder, success);
        String requestId = request.getAttachments().get(URLParamType.requestIdFromClient.getName());
        if (StringUtils.isBlank((CharSequence)requestId)) {
            requestId = String.valueOf(request.getRequestId());
        }
        this.append(builder, requestId);
        this.append(builder, request.getAttachments().get("Content-Length"));
        this.append(builder, response == null ? "0" : response.getAttachments().get("Content-Length"));
        this.append(builder, segmentTime);
        this.append(builder, wholeTime);
        LoggerUtil.accessLog(builder.substring(0, builder.length() - 1));
    }

    private void append(StringBuilder builder, Object field) {
        if (field != null) {
            builder.append(StringTools.urlEncode(field.toString()));
        }
        builder.append("|");
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    static {
        MotanSwitcherUtil.initSwitcher(ACCESS_LOG_SWITCHER_NAME, false);
        MotanSwitcherUtil.initSwitcher(PRINT_TRACE_LOG_SWITCHER_NAME, true);
    }
}

