/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.admin;

import com.weibo.api.motan.admin.AdminCommandHandler;
import com.weibo.api.motan.admin.AdminServer;
import com.weibo.api.motan.admin.AdminServerFactory;
import com.weibo.api.motan.admin.AdminUtil;
import com.weibo.api.motan.admin.handler.CommandListHandler;
import com.weibo.api.motan.admin.handler.MetaInfoHandler;
import com.weibo.api.motan.admin.handler.RuntimeInfoHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.rpc.init.Initializable;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="admin")
public class AdminInitialization
implements Initializable {
    private static final String DEFAULT_ADMIN_SERVER = "netty4";
    private static final String SECOND_DEFAULT_ADMIN_SERVER = "netty3";
    private static final String DEFAULT_ADMIN_PROTOCOL = "http";

    @Override
    public void init() {
        try {
            int port = this.getAdminPort();
            if (port >= 0) {
                AdminServerFactory adminServerFactory;
                String adminServerString = MotanGlobalConfigUtil.getConfig("admin.server");
                if (StringUtils.isNotBlank((CharSequence)adminServerString)) {
                    adminServerFactory = ExtensionLoader.getExtensionLoader(AdminServerFactory.class).getExtension(adminServerString);
                } else {
                    adminServerFactory = ExtensionLoader.getExtensionLoader(AdminServerFactory.class).getExtension(DEFAULT_ADMIN_SERVER, false);
                    if (adminServerFactory == null) {
                        adminServerFactory = ExtensionLoader.getExtensionLoader(AdminServerFactory.class).getExtension(SECOND_DEFAULT_ADMIN_SERVER);
                    }
                }
                URL adminUrl = new URL(MotanGlobalConfigUtil.getConfig("admin.protocol", DEFAULT_ADMIN_PROTOCOL), "127.0.0.1", port, "/", MotanGlobalConfigUtil.getConfigs().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("admin.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("admin.".length()), Map.Entry::getValue)));
                this.addDefaultHandlers();
                this.addExtHandlers(MotanGlobalConfigUtil.getConfig("admin.extHandlers"));
                this.addExtHandlers(System.getenv("MOTAN_ADMIN_EXT_HANDLERS"));
                AdminServer adminServer = adminServerFactory.createServer(adminUrl, AdminUtil.getDefaultAdminHandler());
                adminServer.open();
                LoggerUtil.info("admin server is open. url:" + adminUrl.toFullStr());
            }
        }
        catch (Exception e) {
            LoggerUtil.error("admin server open fail.", e);
        }
    }

    private int getAdminPort() {
        int port = -1;
        if ("true".equals(MotanGlobalConfigUtil.getConfig("admin.disable"))) {
            return port;
        }
        port = this.parsePort(System.getenv("MOTAN_ADMIN_PORT"));
        if (port < 0) {
            port = this.parsePort(MotanGlobalConfigUtil.getConfig("admin.port"));
        }
        if (port < 0) {
            port = 9002;
        }
        return port;
    }

    private int parsePort(String portStr) {
        int port = -1;
        if (StringUtils.isNotBlank((CharSequence)portStr)) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                LoggerUtil.warn("AdminInitialization parse admin port from env fail. value:" + portStr);
            }
        }
        return port;
    }

    private void addDefaultHandlers() {
        AdminUtil.addCommandHandler(new CommandListHandler());
        AdminUtil.addCommandHandler(new RuntimeInfoHandler());
        AdminUtil.addCommandHandler(new MetaInfoHandler());
    }

    private void addExtHandlers(String handlerString) {
        if (handlerString != null) {
            String[] handlers;
            for (String h : handlers = handlerString.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)h)) continue;
                try {
                    AdminCommandHandler handler = ExtensionLoader.getExtensionLoader(AdminCommandHandler.class).getExtension(h.trim());
                    AdminUtil.addCommandHandler(handler, true);
                    LoggerUtil.info("admin server add handler " + handler.getClass().getName());
                }
                catch (Exception e) {
                    LoggerUtil.warn("can not find admin command handler :" + h);
                }
            }
        }
    }
}

