/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbstractLoadBalance<T>
implements LoadBalance<T> {
    public static final int MAX_REFERER_COUNT = 10;
    protected URL clusterUrl;
    private List<Referer<T>> referers;

    @Override
    public void init(URL clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        this.onRefresh(referers, true);
    }

    protected void onRefresh(List<Referer<T>> referers, boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(referers);
        }
        this.referers = referers;
    }

    @Override
    public Referer<T> select(Request request) {
        List<Referer<T>> referers = this.referers;
        if (referers == null) {
            throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call request:" + request);
        }
        Referer<T> ref = null;
        if (referers.size() > 1) {
            ref = this.doSelect(request);
        } else if (referers.size() == 1) {
            Referer<T> referer = ref = referers.get(0).isAvailable() ? referers.get(0) : null;
        }
        if (ref != null) {
            return ref;
        }
        throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call request:" + request);
    }

    @Override
    public void selectToHolder(Request request, List<Referer<T>> refersHolder) {
        List<Referer<T>> referers = this.referers;
        if (referers == null) {
            throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call : referers_size= 0 " + MotanFrameworkUtil.toString(request));
        }
        if (referers.size() > 1) {
            this.doSelectToHolder(request, refersHolder);
        } else if (referers.size() == 1 && referers.get(0).isAvailable()) {
            refersHolder.add(referers.get(0));
        }
        if (refersHolder.isEmpty()) {
            throw new MotanServiceException(this.getClass().getSimpleName() + " No available referers for call : referers_size=" + referers.size() + " " + MotanFrameworkUtil.toString(request));
        }
    }

    protected List<Referer<T>> getReferers() {
        return this.referers;
    }

    protected Referer<T> selectFromRandomStart(List<Referer<T>> referers) {
        int index = ThreadLocalRandom.current().nextInt(referers.size());
        for (int i = 0; i < referers.size(); ++i) {
            Referer<T> ref = referers.get((i + index) % referers.size());
            if (!ref.isAvailable()) continue;
            return ref;
        }
        return null;
    }

    protected void addToSelectHolderFromStart(List<Referer<T>> referers, List<Referer<T>> refersHolder, int start) {
        int count = 0;
        for (int i = 0; i < referers.size() && count < 10; ++i) {
            Referer<T> referer = referers.get((i + start) % referers.size());
            if (!referer.isAvailable()) continue;
            refersHolder.add(referer);
            ++count;
        }
    }

    @Override
    public void setWeightString(String weightString) {
        LoggerUtil.info("ignore weightString:" + weightString);
    }

    protected abstract Referer<T> doSelect(Request var1);

    protected abstract void doSelectToHolder(Request var1, List<Referer<T>> var2);
}

