/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.support;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.HaStrategy;
import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.RefererSupports;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@SpiMeta(name="default")
public class ClusterSpi<T>
implements Cluster<T> {
    private HaStrategy<T> haStrategy;
    private LoadBalance<T> loadBalance;
    private List<Referer<T>> referers;
    private AtomicBoolean available = new AtomicBoolean(false);
    private URL url;

    @Override
    public void init() {
        this.available.set(true);
    }

    @Override
    public Class<T> getInterface() {
        if (this.referers == null || this.referers.isEmpty()) {
            return null;
        }
        return this.referers.get(0).getInterface();
    }

    @Override
    public Response call(Request request) {
        if (this.available.get()) {
            try {
                return this.haStrategy.call(request, this.loadBalance);
            }
            catch (Exception e) {
                return this.callFalse(request, e);
            }
        }
        throw new MotanServiceException(String.format("ClusterSpi Call false for request: %s, ClusterSpi not created or destroyed", request), MotanErrorMsgConstant.SERVICE_UNFOUND, false);
    }

    @Override
    public String desc() {
        return this.toString();
    }

    @Override
    public void destroy() {
        this.available.set(false);
        this.loadBalance.destroy();
        for (Referer<T> referer : this.referers) {
            referer.destroy();
        }
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public boolean isAvailable() {
        return this.available.get();
    }

    public String toString() {
        return "cluster: {ha=" + this.haStrategy + ",loadBalance=" + this.loadBalance + "referers=" + this.referers + "}";
    }

    @Override
    public synchronized void onRefresh(List<Referer<T>> referers) {
        if (CollectionUtil.isEmpty(referers)) {
            return;
        }
        this.loadBalance.onRefresh(referers);
        List<Referer<T>> oldReferers = this.referers;
        this.referers = referers;
        this.haStrategy.setUrl(this.getUrl());
        if (oldReferers == null || oldReferers.isEmpty()) {
            return;
        }
        ArrayList delayDestroyReferers = new ArrayList();
        for (Referer<T> referer : oldReferers) {
            if (referers.contains(referer)) continue;
            delayDestroyReferers.add(referer);
        }
        if (!delayDestroyReferers.isEmpty()) {
            RefererSupports.delayDestroy(delayDestroyReferers);
        }
    }

    public AtomicBoolean getAvailable() {
        return this.available;
    }

    public void setAvailable(AtomicBoolean available) {
        this.available = available;
    }

    public HaStrategy<T> getHaStrategy() {
        return this.haStrategy;
    }

    @Override
    public void setHaStrategy(HaStrategy<T> haStrategy) {
        this.haStrategy = haStrategy;
    }

    @Override
    public LoadBalance<T> getLoadBalance() {
        return this.loadBalance;
    }

    @Override
    public void setLoadBalance(LoadBalance<T> loadBalance) {
        this.loadBalance = loadBalance;
    }

    @Override
    public List<Referer<T>> getReferers() {
        return this.referers;
    }

    protected Response callFalse(Request request, Exception cause) {
        if (ExceptionUtil.isBizException(cause)) {
            throw (RuntimeException)cause;
        }
        if (Boolean.parseBoolean(this.getUrl().getParameter(URLParamType.throwException.getName(), URLParamType.throwException.getValue()))) {
            if (cause instanceof MotanAbstractException) {
                throw (MotanAbstractException)cause;
            }
            throw new MotanServiceException(String.format("ClusterSpi Call false for request: %s", request), cause);
        }
        return MotanFrameworkUtil.buildErrorResponse(request, cause);
    }

    @Override
    public Map<String, Object> getRuntimeInfo() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("url", this.url.toFullStr());
        infos.put("refererSize", this.referers == null ? 0 : this.referers.size());
        if (!CollectionUtil.isEmpty(this.referers)) {
            this.addCommonInfos(this.referers.get(0), infos, "codec", "fusingThreshold");
            HashMap<String, Map<String, Object>> availableInfos = new HashMap<String, Map<String, Object>>();
            HashMap<String, Map<String, Object>> unavailableInfos = new HashMap<String, Map<String, Object>>();
            int i = 0;
            for (Referer<T> referer : this.referers) {
                if (referer.isAvailable()) {
                    availableInfos.put(i + "-" + referer.getUrl().toTinyString(), this.removeCommonInfos(referer, "codec", "fusingThreshold"));
                } else {
                    unavailableInfos.put(i + "-" + referer.getUrl().toTinyString(), this.removeCommonInfos(referer, "codec", "fusingThreshold"));
                }
                ++i;
            }
            HashMap<String, HashMap<String, Map<String, Object>>> refererInfos = new HashMap<String, HashMap<String, Map<String, Object>>>();
            refererInfos.put("available", availableInfos);
            refererInfos.put("unavailable", unavailableInfos);
            infos.put("referers", refererInfos);
        }
        return infos;
    }

    private Map<String, Object> removeCommonInfos(Referer<?> referer, String ... keys) {
        Map<String, Object> refererInfos = referer.getRuntimeInfo();
        if (!CollectionUtil.isEmpty(refererInfos)) {
            for (String key : keys) {
                refererInfos.remove(key);
            }
        }
        return refererInfos;
    }

    private void addCommonInfos(Referer<?> referer, Map<String, Object> infos, String ... keys) {
        Map<String, Object> refererInfos = referer.getRuntimeInfo();
        if (!CollectionUtil.isEmpty(refererInfos)) {
            for (String key : keys) {
                if (refererInfos.get(key) == null) continue;
                infos.put(key, refererInfos.get(key));
            }
        }
    }
}

