/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.config.GlobalConfig;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultGlobalConfig
implements GlobalConfig {
    private final ConcurrentHashMap<String, String> configs = new ConcurrentHashMap();

    public DefaultGlobalConfig() {
        Map<String, String> defaultConfigs = MotanGlobalConfigUtil.getDefaultConfigCopy();
        if (!defaultConfigs.isEmpty()) {
            this.putConfigs(defaultConfigs, false);
        }
    }

    @Override
    public String getConfig(String key) {
        return this.configs.get(key);
    }

    @Override
    public String getConfig(String key, String defaultValue) {
        String value = this.configs.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public void putConfig(String key, String value) {
        this.configs.put(key, value);
    }

    @Override
    public String remove(String key) {
        return this.configs.remove(key);
    }

    @Override
    public void putConfigs(Map<String, String> configs, boolean override) {
        if (configs != null && !configs.isEmpty()) {
            for (Map.Entry<String, String> entry : configs.entrySet()) {
                if (override) {
                    this.configs.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.configs.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public ConcurrentHashMap<String, String> getConfigs() {
        return this.configs;
    }
}

