/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="faultInjection")
public class FaultInjectionFilter
implements Filter {
    @Override
    public Response filter(Caller<?> caller, Request request) {
        long delay;
        Response response;
        FaultInjectionConfig config = FaultInjectionUtil.getGlobalFaultInjectionConfig(request.getInterfaceName(), request.getMethodName());
        if (config == null) {
            return caller.call(request);
        }
        Exception exception = config.getException();
        if (exception != null) {
            response = MotanFrameworkUtil.buildErrorResponse(request, exception);
            delay = config.getExceptionTime();
        } else {
            response = caller.call(request);
            delay = config.getDelayTime(response.getProcessTime());
        }
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            response.setProcessTime(response.getProcessTime() + delay);
        }
        return response;
    }

    public static class FaultInjectionUtil {
        private static final String SEPARATOR = "-";
        private static final FaultInjectionConfig NOT_MATCH = new FaultInjectionConfig();
        private static final ConcurrentHashMap<String, FaultInjectionConfig> matchCache = new ConcurrentHashMap();
        private static List<FaultInjectionConfig> configList;

        public static void updateConfigs(List<FaultInjectionConfig> configList) {
            configList.forEach(FaultInjectionConfig::init);
            FaultInjectionUtil.configList = configList;
            matchCache.clear();
        }

        public static void clearConfigs() {
            configList = null;
            matchCache.clear();
        }

        public static List<FaultInjectionConfig> getConfigs() {
            return configList;
        }

        public static FaultInjectionConfig getGlobalFaultInjectionConfig(String service, String method) {
            if (configList == null) {
                return null;
            }
            FaultInjectionConfig config = matchCache.get(service + SEPARATOR + method);
            if (config == null) {
                List<FaultInjectionConfig> configs = configList;
                for (FaultInjectionConfig temp : configs) {
                    if (!temp.isMatch(service, method)) continue;
                    config = temp;
                    break;
                }
                if (config == null) {
                    config = NOT_MATCH;
                }
                matchCache.put(service + SEPARATOR + method, config);
            }
            if (config == NOT_MATCH) {
                return null;
            }
            return config;
        }
    }

    public static class FaultInjectionConfig {
        public String id;
        public String servicePattern;
        public String methodPattern;
        public float delayRatio;
        public long delayTime;
        public int exceptionPercent;
        public long exceptionTime;
        public String exceptionType;
        private Class<? extends Exception> exceptionClass;

        public boolean isMatch(String service, String method) {
            boolean match = this.isMatch0(this.servicePattern, service);
            if (match && StringUtils.isNotBlank((CharSequence)this.methodPattern)) {
                return this.isMatch0(this.methodPattern, method);
            }
            return match;
        }

        private boolean isMatch0(String pattern, String str) {
            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                return Pattern.matches(pattern, str);
            }
            return false;
        }

        public Exception getException() {
            if (this.shouldException()) {
                if (this.exceptionClass != null) {
                    try {
                        Exception exception = this.exceptionClass.newInstance();
                        if (exception instanceof MotanAbstractException) {
                            return exception;
                        }
                        return new MotanBizException(exception);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new MotanServiceException("exception from FaultInjectionFilter");
            }
            return null;
        }

        private boolean shouldException() {
            if (this.exceptionPercent > 0) {
                if (this.exceptionPercent >= 100) {
                    return true;
                }
                return this.exceptionPercent > ThreadLocalRandom.current().nextInt(100);
            }
            return false;
        }

        public long getDelayTime(long responseTime) {
            if (this.delayTime > 0L) {
                return this.delayTime;
            }
            if (this.delayRatio > 0.0f) {
                return (long)((float)responseTime * this.delayRatio);
            }
            return 0L;
        }

        public long getExceptionTime() {
            return this.exceptionTime;
        }

        public void init() {
            if (this.exceptionType != null) {
                try {
                    this.exceptionClass = Class.forName(this.exceptionType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

