/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.support;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.ActivationComparator;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.filter.InitializableFilter;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import com.weibo.api.motan.util.StringTools;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ProtocolFilterDecorator
implements Protocol {
    private Protocol protocol;

    public ProtocolFilterDecorator(Protocol protocol) {
        if (protocol == null) {
            throw new MotanFrameworkException("Protocol is null when construct ProtocolFilterDecorator", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.protocol = protocol;
    }

    @Override
    public <T> Exporter<T> export(Provider<T> provider, URL url) {
        return this.protocol.export(this.decorateWithFilter(provider, url), url);
    }

    @Override
    public <T> Referer<T> refer(Class<T> clz, URL url, URL serviceUrl) {
        return this.decorateWithFilter(this.protocol.refer(clz, url, serviceUrl), url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    public <T> Referer<T> decorateRefererFilter(Referer<T> referer, URL url) {
        return this.decorateWithFilter(referer, url);
    }

    private <T> Referer<T> decorateWithFilter(Referer<T> referer, URL url) {
        List<Filter> filters = this.getFilters(url, "referer");
        Referer lastRef = referer;
        for (Filter filter : filters) {
            final Filter f = filter;
            if (f instanceof InitializableFilter) {
                ((InitializableFilter)f).init(lastRef);
            }
            final Referer lr = lastRef;
            lastRef = new Referer<T>(){

                @Override
                public Response call(Request request) {
                    Activation activation = f.getClass().getAnnotation(Activation.class);
                    if (activation != null && !activation.retry() && request.getRetries() != 0) {
                        return lr.call(request);
                    }
                    return f.filter(lr, request);
                }

                @Override
                public String desc() {
                    return lr.desc();
                }

                @Override
                public void destroy() {
                    lr.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lr.getInterface();
                }

                @Override
                public URL getUrl() {
                    return lr.getUrl();
                }

                @Override
                public void init() {
                    lr.init();
                }

                @Override
                public boolean isAvailable() {
                    return lr.isAvailable();
                }

                @Override
                public int activeRefererCount() {
                    return lr.activeRefererCount();
                }

                @Override
                public URL getServiceUrl() {
                    return lr.getServiceUrl();
                }

                @Override
                public Map<String, Object> getRuntimeInfo() {
                    return ProtocolFilterDecorator.this.addFilterRuntimeInfo(lr.getRuntimeInfo(), f);
                }
            };
        }
        return lastRef;
    }

    private <T> Provider<T> decorateWithFilter(final Provider<T> provider, URL url) {
        List<Filter> filters = this.getFilters(url, "service");
        if (filters == null || filters.isEmpty()) {
            return provider;
        }
        Provider lastProvider = provider;
        for (Filter filter : filters) {
            final Filter f = filter;
            if (f instanceof InitializableFilter) {
                ((InitializableFilter)f).init(lastProvider);
            }
            final Provider lp = lastProvider;
            lastProvider = new Provider<T>(){

                @Override
                public Response call(Request request) {
                    return f.filter(lp, request);
                }

                @Override
                public String desc() {
                    return lp.desc();
                }

                @Override
                public void destroy() {
                    lp.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lp.getInterface();
                }

                @Override
                public Method lookupMethod(String methodName, String methodDesc) {
                    return lp.lookupMethod(methodName, methodDesc);
                }

                @Override
                public URL getUrl() {
                    return lp.getUrl();
                }

                @Override
                public void init() {
                    lp.init();
                }

                @Override
                public boolean isAvailable() {
                    return lp.isAvailable();
                }

                @Override
                public T getImpl() {
                    return provider.getImpl();
                }

                @Override
                public Map<String, Object> getRuntimeInfo() {
                    return ProtocolFilterDecorator.this.addFilterRuntimeInfo(lp.getRuntimeInfo(), f);
                }
            };
        }
        return lastProvider;
    }

    private Map<String, Object> addFilterRuntimeInfo(Map<String, Object> baseRuntimeInfo, Filter f) {
        Map<String, Object> filterRuntimeInfos;
        if (baseRuntimeInfo != null && !CollectionUtil.isEmpty(filterRuntimeInfos = f.getRuntimeInfo())) {
            HashMap filterInfos = baseRuntimeInfo.get("filters");
            if (!(filterInfos instanceof Map)) {
                filterInfos = new HashMap();
                baseRuntimeInfo.put("filters", filterInfos);
            }
            ((Map)filterInfos).put(f.getClass().getSimpleName(), filterRuntimeInfos);
        }
        return baseRuntimeInfo;
    }

    protected List<Filter> getFilters(URL url, String key) {
        String filterStr;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        List<Filter> defaultFilters = ExtensionLoader.getExtensionLoader(Filter.class).getExtensions(key);
        if (defaultFilters != null && !defaultFilters.isEmpty()) {
            filters.addAll(defaultFilters);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterStr = StringTools.joinNotBlank(",", url.getParameter(URLParamType.filter.getName()), System.getenv("MOTAN_GLOBAL_FILTERS"), MotanGlobalConfigUtil.getConfig("MOTAN_GLOBAL_FILTERS"))))) {
            HashSet<String> removedFilters = new HashSet<String>();
            Set<String> filterNames = StringTools.splitSet(filterStr, ",");
            for (String fn : filterNames) {
                if (fn.startsWith("-")) {
                    if (fn.length() <= "-".length()) continue;
                    removedFilters.add(fn.substring("-".length()).trim());
                    continue;
                }
                Filter extFilter = ExtensionLoader.getExtensionLoader(Filter.class).getExtension(fn, false);
                if (extFilter == null) {
                    LoggerUtil.warn("filter extension not found. filer name: " + fn);
                    continue;
                }
                filters.add(extFilter);
            }
            if (!removedFilters.isEmpty()) {
                for (String removedName : removedFilters) {
                    filters.removeIf(filter -> removedName.equals(filter.getClass().getAnnotation(SpiMeta.class).name()));
                }
            }
        }
        filters.sort(new ActivationComparator());
        Collections.reverse(filters);
        return filters;
    }
}

