/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support;

import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.registry.RegistryFactory;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRegistryFactory
implements RegistryFactory {
    private static final ConcurrentHashMap<String, Registry> registries = new ConcurrentHashMap();
    private static final ReentrantLock lock = new ReentrantLock();

    protected String getRegistryUri(URL url) {
        return url.getUri();
    }

    @Override
    public Registry getRegistry(URL url) {
        String registryUri = this.getRegistryUri(url);
        try {
            lock.lock();
            Registry registry = registries.get(registryUri);
            if (registry != null) {
                Registry registry2 = registry;
                return registry2;
            }
            registry = this.createRegistry(url);
            if (registry == null) {
                throw new MotanFrameworkException("Create registry false for url:" + url, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
            }
            registries.put(registryUri, registry);
            GlobalRuntime.addRegistry(registryUri, registry);
            Registry registry3 = registry;
            return registry3;
        }
        catch (Exception e) {
            throw new MotanFrameworkException("Create registry false for url:" + url, e, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract Registry createRegistry(URL var1);
}

