/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.consul;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.registry.consul.ConsulConstants;
import com.weibo.api.motan.registry.consul.ConsulService;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsulUtils {
    public static boolean isSame(List<URL> urls1, List<URL> urls2) {
        if (urls1 == null || urls2 == null) {
            return false;
        }
        if (urls1.size() != urls2.size()) {
            return false;
        }
        return urls1.containsAll(urls2);
    }

    public static ConsulService buildService(URL url) {
        ConsulService service = new ConsulService();
        service.setAddress(url.getHost());
        service.setId(ConsulUtils.convertConsulSerivceId(url));
        service.setName(ConsulUtils.convertGroupToServiceName(url.getGroup()));
        service.setPort(url.getPort());
        service.setTtl(ConsulConstants.TTL);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("protocol_" + url.getProtocol());
        tags.add("URL_" + StringTools.urlEncode((String)url.toFullStr()));
        service.setTags(tags);
        return service;
    }

    public static URL buildUrl(ConsulService service) {
        URL url = null;
        for (String tag : service.getTags()) {
            if (!tag.startsWith("URL_")) continue;
            String encodeUrl = tag.substring(tag.indexOf("_") + 1);
            url = URL.valueOf((String)StringTools.urlDecode((String)encodeUrl));
        }
        if (url == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            String group = service.getName().substring("motanrpc_".length());
            params.put(URLParamType.group.getName(), group);
            params.put(URLParamType.nodeType.getName(), "service");
            String protocol = ConsulUtils.getProtocolFromTag(service.getTags().get(0));
            url = new URL(protocol, service.getAddress(), service.getPort().intValue(), ConsulUtils.getPathFromServiceId(service.getId()), params);
        }
        return url;
    }

    public static String getUrlClusterInfo(URL url) {
        return url.getProtocol() + "-" + url.getPath();
    }

    public static String convertGroupToServiceName(String group) {
        return "motanrpc_" + group;
    }

    public static String getGroupFromServiceName(String group) {
        return group.substring("motanrpc_".length());
    }

    public static String convertConsulSerivceId(URL url) {
        if (url == null) {
            return null;
        }
        return ConsulUtils.convertServiceId(url.getHost(), url.getPort(), url.getPath());
    }

    public static String getPathFromServiceId(String serviceId) {
        return serviceId.substring(serviceId.indexOf("-") + 1);
    }

    public static String getProtocolFromTag(String tag) {
        return tag.substring("protocol_".length());
    }

    public static String convertServiceId(String host, int port, String path) {
        return host + ":" + port + "-" + path;
    }
}

