/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.consul;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.registry.consul.ConsulConstants;
import com.weibo.api.motan.registry.consul.ConsulHeartbeatManager;
import com.weibo.api.motan.registry.consul.ConsulResponse;
import com.weibo.api.motan.registry.consul.ConsulService;
import com.weibo.api.motan.registry.consul.ConsulUtils;
import com.weibo.api.motan.registry.consul.client.MotanConsulClient;
import com.weibo.api.motan.registry.support.command.CommandFailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsulRegistry
extends CommandFailbackRegistry {
    private MotanConsulClient client;
    private ConsulHeartbeatManager heartbeatManager;
    private int lookupInterval;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, List<URL>>> serviceCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> commandCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lookupGroupServices = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> lookupGroupCommands = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> serviceListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, CommandListener>> commandListeners = new ConcurrentHashMap();
    private ThreadPoolExecutor notifyExecutor;

    public ConsulRegistry(URL url, MotanConsulClient client) {
        super(url);
        this.client = client;
        this.heartbeatManager = new ConsulHeartbeatManager(client);
        this.heartbeatManager.start();
        this.lookupInterval = this.getUrl().getIntParameter(URLParamType.registrySessionTimeout.getName(), ConsulConstants.DEFAULT_LOOKUP_INTERVAL);
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(20000);
        this.notifyExecutor = new ThreadPoolExecutor(10, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
        LoggerUtil.info((String)"ConsulRegistry init finish.");
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> getServiceListeners() {
        return this.serviceListeners;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<URL, CommandListener>> getCommandListeners() {
        return this.commandListeners;
    }

    protected void doRegister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.registerService(service);
        this.heartbeatManager.addHeartbeatServcieId(service.getId());
    }

    protected void doUnregister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.unregisterService(service.getId());
        this.heartbeatManager.removeHeartbeatServiceId(service.getId());
    }

    protected void doAvailable(URL url) {
        if (url != null) {
            throw new UnsupportedOperationException("Command consul registry not support available by urls yet");
        }
        this.heartbeatManager.setHeartbeatOpen(true);
    }

    protected void doUnavailable(URL url) {
        if (url != null) {
            throw new UnsupportedOperationException("Command consul registry not support unavailable by urls yet");
        }
        this.heartbeatManager.setHeartbeatOpen(false);
    }

    protected void subscribeService(URL url, ServiceListener serviceListener) {
        this.addServiceListener(url, serviceListener);
        this.startListenerThreadIfNewService(url);
    }

    private void startListenerThreadIfNewService(URL url) {
        Long value;
        String group = url.getGroup();
        if (!this.lookupGroupServices.containsKey(group) && (value = this.lookupGroupServices.putIfAbsent(group, 0L)) == null) {
            ServiceLookupThread lookupThread = new ServiceLookupThread(group);
            lookupThread.setDaemon(true);
            lookupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(URL url, ServiceListener serviceListener) {
        String service = ConsulUtils.getUrlClusterInfo(url);
        ConcurrentHashMap<URL, ServiceListener> map = this.serviceListeners.get(service);
        if (map == null) {
            this.serviceListeners.putIfAbsent(service, new ConcurrentHashMap());
            map = this.serviceListeners.get(service);
        }
        ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            map.put(url, serviceListener);
        }
    }

    protected void subscribeCommand(URL url, CommandListener commandListener) {
        this.addCommandListener(url, commandListener);
        this.startListenerThreadIfNewCommand(url);
    }

    private void startListenerThreadIfNewCommand(URL url) {
        String command;
        String group = url.getGroup();
        if (!this.lookupGroupCommands.containsKey(group) && (command = this.lookupGroupCommands.putIfAbsent(group, "")) == null) {
            CommandLookupThread lookupThread = new CommandLookupThread(group);
            lookupThread.setDaemon(true);
            lookupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandListener(URL url, CommandListener commandListener) {
        String group = url.getGroup();
        ConcurrentHashMap<URL, CommandListener> map = this.commandListeners.get(group);
        if (map == null) {
            this.commandListeners.putIfAbsent(group, new ConcurrentHashMap());
            map = this.commandListeners.get(group);
        }
        ConcurrentHashMap<URL, CommandListener> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            map.put(url, commandListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeService(URL url, ServiceListener listener) {
        ConcurrentHashMap<URL, ServiceListener> listeners = this.serviceListeners.get(ConsulUtils.getUrlClusterInfo(url));
        if (listeners != null) {
            ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = listeners;
            synchronized (concurrentHashMap) {
                listeners.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeCommand(URL url, CommandListener listener) {
        ConcurrentHashMap<URL, CommandListener> listeners = this.commandListeners.get(url.getGroup());
        if (listeners != null) {
            ConcurrentHashMap<URL, CommandListener> concurrentHashMap = listeners;
            synchronized (concurrentHashMap) {
                listeners.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<URL> discoverService(URL url) {
        String service = ConsulUtils.getUrlClusterInfo(url);
        String group = url.getGroup();
        List<URL> serviceUrls = new ArrayList<URL>();
        ConcurrentHashMap<String, List<URL>> serviceMap = this.serviceCache.get(group);
        if (serviceMap == null) {
            String string = group.intern();
            synchronized (string) {
                serviceMap = this.serviceCache.get(group);
                if (serviceMap == null) {
                    ConcurrentHashMap<String, List<URL>> groupUrls = this.lookupServiceUpdate(group);
                    this.updateServiceCache(group, groupUrls, false);
                    serviceMap = this.serviceCache.get(group);
                }
            }
        }
        if (serviceMap != null) {
            serviceUrls = serviceMap.get(service);
        }
        return serviceUrls;
    }

    protected String discoverCommand(URL url) {
        String group = url.getGroup();
        String command = this.lookupCommandUpdate(group);
        this.updateCommandCache(group, command, false);
        return command;
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String group) {
        Long lastConsulIndexId = this.lookupGroupServices.get(group) == null ? 0L : this.lookupGroupServices.get(group);
        ConsulResponse<List<ConsulService>> response = this.lookupConsulService(group, lastConsulIndexId);
        if (response != null) {
            List<ConsulService> services = response.getValue();
            if (services != null && !services.isEmpty() && response.getConsulIndex() > lastConsulIndexId) {
                ConcurrentHashMap<String, List<URL>> groupUrls = new ConcurrentHashMap<String, List<URL>>();
                for (ConsulService service : services) {
                    try {
                        URL url = ConsulUtils.buildUrl(service);
                        String cluster = ConsulUtils.getUrlClusterInfo(url);
                        List<URL> urlList = groupUrls.get(cluster);
                        if (urlList == null) {
                            urlList = new ArrayList<URL>();
                            groupUrls.put(cluster, urlList);
                        }
                        urlList.add(url);
                    }
                    catch (Exception e) {
                        LoggerUtil.error((String)("convert consul service to url fail! service:" + service), (Throwable)e);
                    }
                }
                this.lookupGroupServices.put(group, response.getConsulIndex());
                return groupUrls;
            }
            LoggerUtil.info((String)(group + " no need update, lastIndex:" + lastConsulIndexId));
        }
        return null;
    }

    private String lookupCommandUpdate(String group) {
        String command = this.client.lookupCommand(group);
        this.lookupGroupCommands.put(group, command);
        return command;
    }

    private ConsulResponse<List<ConsulService>> lookupConsulService(String serviceName, Long lastConsulIndexId) {
        ConsulResponse<List<ConsulService>> response = this.client.lookupHealthService(ConsulUtils.convertGroupToServiceName(serviceName), lastConsulIndexId);
        return response;
    }

    private void updateServiceCache(String group, ConcurrentHashMap<String, List<URL>> groupUrls, boolean needNotify) {
        if (groupUrls != null && !groupUrls.isEmpty()) {
            ConcurrentHashMap<String, List<URL>> groupMap = this.serviceCache.get(group);
            if (groupMap == null) {
                this.serviceCache.put(group, groupUrls);
            }
            for (Map.Entry<String, List<URL>> entry : groupUrls.entrySet()) {
                boolean change = true;
                if (groupMap != null) {
                    List<URL> oldUrls = groupMap.get(entry.getKey());
                    List<URL> newUrls = entry.getValue();
                    if (newUrls == null || newUrls.isEmpty() || ConsulUtils.isSame(entry.getValue(), oldUrls)) {
                        change = false;
                    } else {
                        groupMap.put(entry.getKey(), newUrls);
                    }
                }
                if (!change || !needNotify) continue;
                this.notifyExecutor.execute(new NotifyService(entry.getKey(), entry.getValue()));
                LoggerUtil.info((String)("motan service notify-service: " + entry.getKey()));
                StringBuilder sb = new StringBuilder();
                for (URL url : entry.getValue()) {
                    sb.append(url.getUri()).append(";");
                }
                LoggerUtil.info((String)("consul notify urls:" + sb.toString()));
            }
        }
    }

    private void updateCommandCache(String group, String command, boolean needNotify) {
        String oldCommand = this.commandCache.get(group);
        if (!command.equals(oldCommand)) {
            this.commandCache.put(group, command);
            if (needNotify) {
                this.notifyExecutor.execute(new NotifyCommand(group, command));
                LoggerUtil.info((String)String.format("command data change: group=%s, command=%s: ", group, command));
            }
        } else {
            LoggerUtil.info((String)String.format("command data not change: group=%s, command=%s: ", group, command));
        }
    }

    private class NotifyCommand
    implements Runnable {
        private String group;
        private String command;

        public NotifyCommand(String group, String command) {
            this.group = group;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap listeners;
            ConcurrentHashMap concurrentHashMap = listeners = (ConcurrentHashMap)ConsulRegistry.this.commandListeners.get(this.group);
            synchronized (concurrentHashMap) {
                for (Map.Entry entry : listeners.entrySet()) {
                    CommandListener commandListener = (CommandListener)entry.getValue();
                    commandListener.notifyCommand((URL)entry.getKey(), this.command);
                }
            }
        }
    }

    private class NotifyService
    implements Runnable {
        private String service;
        private List<URL> urls;

        public NotifyService(String service, List<URL> urls) {
            this.service = service;
            this.urls = urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ConsulRegistry.this.serviceListeners.get(this.service);
            if (listeners != null) {
                ConcurrentHashMap concurrentHashMap = listeners;
                synchronized (concurrentHashMap) {
                    for (Map.Entry entry : listeners.entrySet()) {
                        ServiceListener serviceListener = (ServiceListener)entry.getValue();
                        serviceListener.notifyService((URL)entry.getKey(), ConsulRegistry.this.getUrl(), this.urls);
                    }
                }
            } else {
                LoggerUtil.debug((String)("need not notify service:" + this.service));
            }
        }
    }

    private class CommandLookupThread
    extends Thread {
        private String group;

        public CommandLookupThread(String group) {
            this.group = group;
        }

        @Override
        public void run() {
            LoggerUtil.info((String)("start command lookup thread. lookup interval: " + ConsulRegistry.this.lookupInterval + "ms, group: " + this.group));
            while (true) {
                try {
                    while (true) {
                        CommandLookupThread.sleep(ConsulRegistry.this.lookupInterval);
                        String command = ConsulRegistry.this.lookupCommandUpdate(this.group);
                        ConsulRegistry.this.updateCommandCache(this.group, command, true);
                    }
                }
                catch (Throwable e) {
                    LoggerUtil.error((String)"group lookup thread fail!", (Throwable)e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    private class ServiceLookupThread
    extends Thread {
        private String group;

        public ServiceLookupThread(String group) {
            this.group = group;
        }

        @Override
        public void run() {
            LoggerUtil.info((String)("start group lookup thread. lookup interval: " + ConsulRegistry.this.lookupInterval + "ms, group: " + this.group));
            while (true) {
                try {
                    while (true) {
                        ServiceLookupThread.sleep(ConsulRegistry.this.lookupInterval);
                        ConcurrentHashMap groupUrls = ConsulRegistry.this.lookupServiceUpdate(this.group);
                        ConsulRegistry.this.updateServiceCache(this.group, groupUrls, true);
                    }
                }
                catch (Throwable e) {
                    LoggerUtil.error((String)"group lookup thread fail!", (Throwable)e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

