/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.cluster.support.ClusterSupport;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.ConfigUtil;
import com.weibo.api.motan.config.ExtConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.springsupport.RefererConfigBean;
import com.weibo.api.motan.config.springsupport.ServiceConfigBean;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import com.weibo.api.motan.config.springsupport.util.SpringBeanUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class AnnotationBean
implements DisposableBean,
BeanFactoryPostProcessor,
BeanPostProcessor,
BeanFactoryAware {
    private String id;
    private String annotationPackage;
    private String[] annotationPackages;
    private BeanFactory beanFactory;
    List<ClusterSupport<?>> clusterSupportList = new ArrayList();
    private final Set<ServiceConfigBean<?>> serviceConfigs = new ConcurrentHashSet();
    private final ConcurrentMap<String, RefererConfigBean> referenceConfigs = new ConcurrentHashMap<String, RefererConfigBean>();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.annotationPackage == null || this.annotationPackage.length() == 0) {
            return;
        }
        if (beanFactory instanceof BeanDefinitionRegistry) {
            try {
                Class scannerClass = ClassUtils.forName((String)"org.springframework.context.annotation.ClassPathBeanDefinitionScanner", (ClassLoader)AnnotationBean.class.getClassLoader());
                Object scanner = scannerClass.getConstructor(BeanDefinitionRegistry.class, Boolean.TYPE).newInstance((BeanDefinitionRegistry)beanFactory, true);
                Class filterClass = ClassUtils.forName((String)"org.springframework.core.type.filter.AnnotationTypeFilter", (ClassLoader)AnnotationBean.class.getClassLoader());
                Object filter = filterClass.getConstructor(Class.class).newInstance(MotanService.class);
                Method addIncludeFilter = scannerClass.getMethod("addIncludeFilter", ClassUtils.forName((String)"org.springframework.core.type.filter.TypeFilter", (ClassLoader)AnnotationBean.class.getClassLoader()));
                addIncludeFilter.invoke(scanner, filter);
                Method scan = scannerClass.getMethod("scan", String[].class);
                scan.invoke(scanner, new Object[]{this.annotationPackages});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        Object value;
        MotanReferer reference;
        Method[] methods;
        if (!this.isMatchPackage(bean)) {
            return bean;
        }
        Class clazz = bean.getClass();
        if (this.isProxyBean(bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        for (Method method : methods = clazz.getMethods()) {
            String name = method.getName();
            if (name.length() <= 3 || !name.startsWith("set") || method.getParameterTypes().length != 1 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            try {
                reference = method.getAnnotation(MotanReferer.class);
                if (reference == null || (value = this.refer(reference, method.getParameterTypes()[0])) == null) continue;
                method.invoke(bean, value);
            }
            catch (Exception e) {
                throw new BeanInitializationException("Failed to init remote service reference at method " + name + " in class " + bean.getClass().getName(), (Throwable)e);
            }
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((reference = field.getAnnotation(MotanReferer.class)) == null || (value = this.refer(reference, field.getType())) == null) continue;
                field.set(bean, value);
            }
            catch (Exception e) {
                throw new BeanInitializationException("Failed to init remote service reference at filed " + field.getName() + " in class " + bean.getClass().getName(), (Throwable)e);
            }
        }
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MotanService service;
        if (!this.isMatchPackage(bean)) {
            return bean;
        }
        Class clazz = bean.getClass();
        if (this.isProxyBean(bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        if ((service = clazz.getAnnotation(MotanService.class)) == null) return bean;
        ServiceConfigBean serviceConfig = new ServiceConfigBean();
        if (Void.TYPE.equals(service.interfaceClass())) {
            if (clazz.getInterfaces().length <= 0) throw new IllegalStateException("Failed to export remote service class " + clazz.getName() + ", cause: The @Service undefined interfaceClass or interfaceName, and the service class unimplemented any interfaces.");
            Class<?> clz = clazz.getInterfaces()[0];
            serviceConfig.setInterface(clz);
        } else {
            serviceConfig.setInterface(service.interfaceClass());
        }
        if (this.beanFactory != null) {
            serviceConfig.setBeanFactory(this.beanFactory);
            if (service.basicService() != null && service.basicService().length() > 0) {
                serviceConfig.setBasicServiceConfig((BasicServiceInterfaceConfig)this.beanFactory.getBean(service.basicService(), BasicServiceInterfaceConfig.class));
            }
            if (service.export() != null && service.export().length() > 0) {
                serviceConfig.setExport(service.export());
            }
            if (service.host() != null && service.host().length() > 0) {
                serviceConfig.setHost(service.host());
            }
            String protocolValue = null;
            if (service.protocol() != null && service.protocol().length() > 0) {
                protocolValue = service.protocol();
            } else if (service.export() != null && service.export().length() > 0) {
                protocolValue = ConfigUtil.extractProtocols((String)service.export());
            }
            if (!StringUtils.isBlank(protocolValue)) {
                List<ProtocolConfig> protocolConfigs = SpringBeanUtil.getMultiBeans(this.beanFactory, protocolValue, "\\s*[,]+\\s*", ProtocolConfig.class);
                serviceConfig.setProtocols(protocolConfigs);
            }
            if (service.registry() != null && service.registry().length() > 0) {
                List<RegistryConfig> registryConfigs = SpringBeanUtil.getMultiBeans(this.beanFactory, service.registry(), "\\s*[,]+\\s*", RegistryConfig.class);
                serviceConfig.setRegistries(registryConfigs);
            }
            if (service.extConfig() != null && service.extConfig().length() > 0) {
                serviceConfig.setExtConfig((ExtConfig)this.beanFactory.getBean(service.extConfig(), ExtConfig.class));
            }
            if (service.application() != null && service.application().length() > 0) {
                serviceConfig.setApplication(service.application());
            }
            if (service.module() != null && service.module().length() > 0) {
                serviceConfig.setModule(service.module());
            }
            if (service.group() != null && service.group().length() > 0) {
                serviceConfig.setGroup(service.group());
            }
            if (service.version() != null && service.version().length() > 0) {
                serviceConfig.setVersion(service.version());
            }
            if (service.proxy() != null && service.proxy().length() > 0) {
                serviceConfig.setProxy(service.proxy());
            }
            if (service.filter() != null && service.filter().length() > 0) {
                serviceConfig.setFilter(service.filter());
            }
            if (service.actives() > 0) {
                serviceConfig.setActives(service.actives());
            }
            if (service.async()) {
                serviceConfig.setAsync(service.async());
            }
            if (service.mock() != null && service.mock().length() > 0) {
                serviceConfig.setMock(service.mock());
            }
            if (service.shareChannel()) {
                serviceConfig.setShareChannel(service.shareChannel());
            }
            if (service.throwException()) {
                serviceConfig.setThrowException(service.throwException());
            }
            if (service.requestTimeout() > 0) {
                serviceConfig.setRequestTimeout(service.requestTimeout());
            }
            if (service.register()) {
                serviceConfig.setRegister(service.register());
            }
            if (service.accessLog()) {
                serviceConfig.setAccessLog("true");
            }
            if (service.check()) {
                serviceConfig.setCheck("true");
            }
            if (service.usegz()) {
                serviceConfig.setUsegz(service.usegz());
            }
            if (service.retries() > 0) {
                serviceConfig.setRetries(service.retries());
            }
            if (service.mingzSize() > 0) {
                serviceConfig.setMingzSize(service.mingzSize());
            }
            if (service.codec() != null && service.codec().length() > 0) {
                serviceConfig.setCodec(service.codec());
            }
            try {
                serviceConfig.afterPropertiesSet();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        serviceConfig.setRef(bean);
        this.serviceConfigs.add(serviceConfig);
        serviceConfig.export();
        return bean;
    }

    public void destroy() throws Exception {
        for (ServiceConfigBean<?> serviceConfig : this.serviceConfigs) {
            try {
                serviceConfig.unexport();
            }
            catch (Throwable e) {
                LoggerUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        for (RefererConfigBean referenceConfig : this.referenceConfigs.values()) {
            try {
                referenceConfig.destroy();
            }
            catch (Throwable e) {
                LoggerUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private <T> Object refer(MotanReferer reference, Class<?> referenceClass) {
        String interfaceName;
        if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (referenceClass.isInterface()) {
            interfaceName = referenceClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the property type " + referenceClass.getName() + " is not a interface.");
        }
        String key = reference.group() + "/" + interfaceName + ":" + reference.version();
        RefererConfigBean referenceConfig = (RefererConfigBean)((Object)this.referenceConfigs.get(key));
        if (referenceConfig == null) {
            referenceConfig = new RefererConfigBean();
            referenceConfig.setBeanFactory(this.beanFactory);
            if (Void.TYPE.equals(reference.interfaceClass()) && referenceClass.isInterface()) {
                referenceConfig.setInterface(referenceClass);
            } else if (!Void.TYPE.equals(reference.interfaceClass())) {
                referenceConfig.setInterface(reference.interfaceClass());
            }
            if (this.beanFactory != null) {
                BasicRefererInterfaceConfig biConfig;
                if (reference.protocol() != null && reference.protocol().length() > 0) {
                    List<ProtocolConfig> protocolConfigs = SpringBeanUtil.getMultiBeans(this.beanFactory, reference.protocol(), "\\s*[,]+\\s*", ProtocolConfig.class);
                    referenceConfig.setProtocols(protocolConfigs);
                }
                if (reference.directUrl() != null && reference.directUrl().length() > 0) {
                    referenceConfig.setDirectUrl(reference.directUrl());
                }
                if (reference.basicReferer() != null && reference.basicReferer().length() > 0 && (biConfig = (BasicRefererInterfaceConfig)this.beanFactory.getBean(reference.basicReferer(), BasicRefererInterfaceConfig.class)) != null) {
                    referenceConfig.setBasicReferer(biConfig);
                }
                if (reference.client() == null || reference.client().length() > 0) {
                    // empty if block
                }
                if (reference.registry() != null && reference.registry().length() > 0) {
                    List<RegistryConfig> registryConfigs = SpringBeanUtil.getMultiBeans(this.beanFactory, reference.registry(), "\\s*[,]+\\s*", RegistryConfig.class);
                    referenceConfig.setRegistries(registryConfigs);
                }
                if (reference.extConfig() != null && reference.extConfig().length() > 0) {
                    referenceConfig.setExtConfig((ExtConfig)this.beanFactory.getBean(reference.extConfig(), ExtConfig.class));
                }
                if (reference.application() != null && reference.application().length() > 0) {
                    referenceConfig.setApplication(reference.application());
                }
                if (reference.module() != null && reference.module().length() > 0) {
                    referenceConfig.setModule(reference.module());
                }
                if (reference.group() != null && reference.group().length() > 0) {
                    referenceConfig.setGroup(reference.group());
                }
                if (reference.version() != null && reference.version().length() > 0) {
                    referenceConfig.setVersion(reference.version());
                }
                if (reference.proxy() != null && reference.proxy().length() > 0) {
                    referenceConfig.setProxy(reference.proxy());
                }
                if (reference.filter() != null && reference.filter().length() > 0) {
                    referenceConfig.setFilter(reference.filter());
                }
                if (reference.actives() > 0) {
                    referenceConfig.setActives(reference.actives());
                }
                if (reference.async()) {
                    referenceConfig.setAsync(reference.async());
                }
                if (reference.mock() != null && reference.mock().length() > 0) {
                    referenceConfig.setMock(reference.mock());
                }
                if (reference.shareChannel()) {
                    referenceConfig.setShareChannel(reference.shareChannel());
                }
                if (reference.throwException()) {
                    referenceConfig.setThrowException(reference.throwException());
                }
                if (reference.requestTimeout() > 0) {
                    referenceConfig.setRequestTimeout(reference.requestTimeout());
                }
                if (reference.register()) {
                    referenceConfig.setRegister(reference.register());
                }
                if (reference.accessLog()) {
                    referenceConfig.setAccessLog("true");
                }
                if (reference.check()) {
                    referenceConfig.setCheck("true");
                }
                if (reference.retries() > 0) {
                    referenceConfig.setRetries(reference.retries());
                }
                if (reference.usegz()) {
                    referenceConfig.setUsegz(reference.usegz());
                }
                if (reference.mingzSize() > 0) {
                    referenceConfig.setMingzSize(reference.mingzSize());
                }
                if (reference.codec() != null && reference.codec().length() > 0) {
                    referenceConfig.setCodec(reference.codec());
                }
                if (reference.mean() != null && reference.mean().length() > 0) {
                    referenceConfig.setMean(reference.mean());
                }
                if (reference.p90() != null && reference.p90().length() > 0) {
                    referenceConfig.setP90(reference.p90());
                }
                if (reference.p99() != null && reference.p99().length() > 0) {
                    referenceConfig.setP99(reference.p99());
                }
                if (reference.p999() != null && reference.p999().length() > 0) {
                    referenceConfig.setP999(reference.p999());
                }
                if (reference.errorRate() != null && reference.errorRate().length() > 0) {
                    referenceConfig.setErrorRate(reference.errorRate());
                }
                try {
                    referenceConfig.afterPropertiesSet();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            this.referenceConfigs.putIfAbsent(key, referenceConfig);
            referenceConfig = (RefererConfigBean)((Object)this.referenceConfigs.get(key));
        }
        return referenceConfig.getRef();
    }

    private boolean isMatchPackage(Object bean) {
        if (this.annotationPackages == null || this.annotationPackages.length == 0) {
            return true;
        }
        Class clazz = bean.getClass();
        if (this.isProxyBean(bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        String beanClassName = clazz.getName();
        for (String pkg : this.annotationPackages) {
            if (!beanClassName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private boolean isProxyBean(Object bean) {
        return AopUtils.isAopProxy((Object)bean);
    }

    public String getPackage() {
        return this.annotationPackage;
    }

    public void setPackage(String annotationPackage) {
        this.annotationPackage = annotationPackage;
        this.annotationPackages = annotationPackage == null || annotationPackage.length() == 0 ? null : annotationPackage.split("\\s*[,]+\\s*");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

