/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.LoggerUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class NettyDecoder
extends FrameDecoder {
    private Codec codec;
    private Channel client;
    private int maxContentLength = 0;

    public NettyDecoder(Codec codec, Channel client, int maxContentLength) {
        this.codec = codec;
        this.client = client;
        this.maxContentLength = maxContentLength;
    }

    protected Object decode(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() <= 16) {
            return null;
        }
        buffer.markReaderIndex();
        short type = buffer.readShort();
        if (type != -3599) {
            buffer.resetReaderIndex();
            throw new MotanFrameworkException("NettyDecoder transport header not support, type: " + type);
        }
        byte messageType = (byte)buffer.readShort();
        long requestId = buffer.readLong();
        int dataLength = buffer.readInt();
        if (buffer.readableBytes() < dataLength) {
            buffer.resetReaderIndex();
            return null;
        }
        if (this.maxContentLength > 0 && dataLength > this.maxContentLength) {
            LoggerUtil.warn((String)"NettyDecoder transport data content length over of limit, size: {}  > {}. remote={} local={}", (Object[])new Object[]{dataLength, this.maxContentLength, ctx.getChannel().getRemoteAddress(), ctx.getChannel().getLocalAddress()});
            MotanServiceException e = new MotanServiceException("NettyDecoder transport data content length over of limit, size: " + dataLength + " > " + this.maxContentLength);
            if (messageType == 0) {
                Response response = this.buildExceptionResponse(requestId, (Exception)((Object)e));
                channel.write((Object)response);
                throw e;
            }
            throw e;
        }
        byte[] data = new byte[dataLength];
        buffer.readBytes(data);
        try {
            String remoteIp = this.getRemoteIp(channel);
            return this.codec.decode(this.client, remoteIp, data);
        }
        catch (Exception e) {
            if (messageType == 0) {
                Response resonse = this.buildExceptionResponse(requestId, e);
                channel.write((Object)resonse);
                return null;
            }
            Response resonse = this.buildExceptionResponse(requestId, e);
            return resonse;
        }
    }

    private Response buildExceptionResponse(long requestId, Exception e) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setException(e);
        return response;
    }

    private String getRemoteIp(org.jboss.netty.channel.Channel channel) {
        String ip = "";
        SocketAddress remote = channel.getRemoteAddress();
        if (remote != null) {
            try {
                ip = ((InetSocketAddress)remote).getAddress().getHostAddress();
            }
            catch (Exception e) {
                LoggerUtil.warn((String)("get remoteIp error!dedault will use. msg:" + e.getMessage() + ", remote:" + remote.toString()));
            }
        }
        return ip;
    }
}

