/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.LoggerUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class NettyDecoder
extends FrameDecoder {
    private Codec codec;
    private Channel client;
    private int maxContentLength = 0;

    public NettyDecoder(Codec codec, Channel client, int maxContentLength) {
        this.codec = codec;
        this.client = client;
        this.maxContentLength = maxContentLength;
    }

    protected Object decode(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() <= 16) {
            return null;
        }
        buffer.markReaderIndex();
        short type = buffer.readShort();
        if (type != -3599) {
            buffer.resetReaderIndex();
            throw new MotanFrameworkException("NettyDecoder transport header not support, type: " + type);
        }
        buffer.skipBytes(1);
        int rpcversion = (buffer.readByte() & 0xFF) >>> 3;
        switch (rpcversion) {
            case 0: {
                return this.decodev1(ctx, channel, buffer);
            }
            case 1: {
                return this.decodev2(ctx, channel, buffer);
            }
        }
        return this.decodev2(ctx, channel, buffer);
    }

    private Object decodev2(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel channel, ChannelBuffer buffer) throws Exception {
        buffer.resetReaderIndex();
        if (buffer.readableBytes() < 21) {
            return null;
        }
        buffer.skipBytes(2);
        boolean isRequest = this.isV2Request(buffer.readByte());
        buffer.skipBytes(2);
        long requestId = buffer.readLong();
        int size = 13;
        int metasize = buffer.readInt();
        size += 4;
        if (metasize > 0) {
            size += metasize;
            if (buffer.readableBytes() < metasize) {
                buffer.resetReaderIndex();
                return null;
            }
            buffer.skipBytes(metasize);
        }
        if (buffer.readableBytes() < 4) {
            buffer.resetReaderIndex();
            return null;
        }
        int bodysize = buffer.readInt();
        this.checkMaxContext(bodysize, ctx, channel, isRequest, requestId);
        size += 4;
        if (bodysize > 0) {
            size += bodysize;
            if (buffer.readableBytes() < bodysize) {
                buffer.resetReaderIndex();
                return null;
            }
        }
        byte[] data = new byte[size];
        buffer.resetReaderIndex();
        buffer.readBytes(data);
        return this.decode(data, channel, isRequest, requestId);
    }

    private boolean isV2Request(byte b) {
        return (b & 1) == 0;
    }

    private Object decodev1(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel channel, ChannelBuffer buffer) throws Exception {
        buffer.resetReaderIndex();
        buffer.skipBytes(2);
        byte messageType = (byte)buffer.readShort();
        long requestId = buffer.readLong();
        int dataLength = buffer.readInt();
        if (buffer.readableBytes() < dataLength) {
            buffer.resetReaderIndex();
            return null;
        }
        this.checkMaxContext(dataLength, ctx, channel, messageType == 0, requestId);
        byte[] data = new byte[dataLength];
        buffer.readBytes(data);
        return this.decode(data, channel, messageType == 0, requestId);
    }

    private void checkMaxContext(int dataLength, ChannelHandlerContext ctx, org.jboss.netty.channel.Channel channel, boolean isRequest, long requestId) throws Exception {
        if (this.maxContentLength > 0 && dataLength > this.maxContentLength) {
            LoggerUtil.warn((String)"NettyDecoder transport data content length over of limit, size: {}  > {}. remote={} local={}", (Object[])new Object[]{dataLength, this.maxContentLength, ctx.getChannel().getRemoteAddress(), ctx.getChannel().getLocalAddress()});
            MotanServiceException e = new MotanServiceException("NettyDecoder transport data content length over of limit, size: " + dataLength + " > " + this.maxContentLength);
            if (isRequest) {
                Response response = this.buildExceptionResponse(requestId, (Exception)((Object)e));
                channel.write((Object)response);
                throw e;
            }
            throw e;
        }
    }

    private Object decode(byte[] data, org.jboss.netty.channel.Channel channel, boolean isRequest, long requestId) {
        try {
            String remoteIp = this.getRemoteIp(channel);
            return this.codec.decode(this.client, remoteIp, data);
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyDecoder decode fail! requestid" + requestId + ", size:" + data.length), (Throwable)e);
            if (isRequest) {
                Response resonse = this.buildExceptionResponse(requestId, e);
                channel.write((Object)resonse);
                return null;
            }
            Response resonse = this.buildExceptionResponse(requestId, e);
            return resonse;
        }
    }

    private Response buildExceptionResponse(long requestId, Exception e) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setException(e);
        return response;
    }

    private String getRemoteIp(org.jboss.netty.channel.Channel channel) {
        String ip = "";
        SocketAddress remote = channel.getRemoteAddress();
        if (remote != null) {
            try {
                ip = ((InetSocketAddress)remote).getAddress().getHostAddress();
            }
            catch (Exception e) {
                LoggerUtil.warn((String)("get remoteIp error!dedault will use. msg:" + e.getMessage() + ", remote:" + remote.toString()));
            }
        }
        return ip;
    }
}

