/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class NettyEncoder
extends OneToOneEncoder {
    private Codec codec;
    private Channel client;

    public NettyEncoder(Codec codec, Channel client) {
        this.codec = codec;
        this.client = client;
    }

    protected Object encode(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel nettyChannel, Object message) throws Exception {
        ChannelBuffer channelBuffer;
        byte[] data = this.encodeMessage(message);
        short type = ByteUtil.bytes2short((byte[])data, (int)0);
        if (type == -3856) {
            channelBuffer = this.encodeV1(message, data);
        } else if (type == -3599) {
            channelBuffer = this.encodeV2(data);
        } else {
            throw new MotanFrameworkException("can not encode message, unknown magic:" + type);
        }
        if (message instanceof Response) {
            ((Response)message).setAttachment("Content-Length", String.valueOf(channelBuffer.readableBytes()));
        }
        if (message instanceof Request) {
            MotanFrameworkUtil.logEvent((Request)((Request)message), (String)"TRACE_CENCODE");
        } else if (message instanceof Response) {
            MotanFrameworkUtil.logEvent((Response)((Response)message), (String)"TRACE_SENCODE");
        }
        return channelBuffer;
    }

    private ChannelBuffer encodeV2(byte[] data) throws Exception {
        return ChannelBuffers.wrappedBuffer((byte[])data);
    }

    private ChannelBuffer encodeV1(Object message, byte[] data) throws Exception {
        long requestId = this.getRequestId(message);
        byte[] transportHeader = new byte[16];
        ByteUtil.short2bytes((short)-3599, (byte[])transportHeader, (int)0);
        transportHeader[3] = this.getType(message);
        ByteUtil.long2bytes((long)requestId, (byte[])transportHeader, (int)4);
        ByteUtil.int2bytes((int)data.length, (byte[])transportHeader, (int)12);
        return ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{transportHeader, data});
    }

    private byte[] encodeMessage(Object message) throws IOException {
        byte[] data = null;
        if (message instanceof Response) {
            try {
                data = this.codec.encode(this.client, message);
            }
            catch (Exception e) {
                LoggerUtil.error((String)("NettyEncoder encode error, identity=" + this.client.getUrl().getIdentity()), (Throwable)e);
                long requestId = this.getRequestId(message);
                DefaultResponse response = MotanFrameworkUtil.buildErrorResponse((long)requestId, (byte)((Response)message).getRpcProtocolVersion(), (Exception)e);
                data = this.codec.encode(this.client, (Object)response);
            }
        } else {
            data = this.codec.encode(this.client, message);
        }
        return data;
    }

    private long getRequestId(Object message) {
        if (message instanceof Request) {
            return ((Request)message).getRequestId();
        }
        if (message instanceof Response) {
            return ((Response)message).getRequestId();
        }
        return 0L;
    }

    private byte getType(Object message) {
        if (message instanceof Request) {
            return 0;
        }
        if (message instanceof Response) {
            return 1;
        }
        return -1;
    }
}

