/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractPoolClient;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty.NettyChannelFactory;
import com.weibo.api.motan.transport.netty.NettyChannelHandler;
import com.weibo.api.motan.transport.netty.NettyDecoder;
import com.weibo.api.motan.transport.netty.NettyEncoder;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class NettyClient
extends AbstractPoolClient
implements StatisticCallback {
    private static final ChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("nettyClientBoss", true)), (Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("nettyClientWorker", true)));
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(4);
    protected ConcurrentMap<Long, ResponseFuture> callbackMap = new ConcurrentHashMap<Long, ResponseFuture>();
    private ScheduledFuture<?> timeMonitorFuture = null;
    private AtomicLong errorCount = new AtomicLong(0L);
    private int fusingThreshold;
    private ClientBootstrap bootstrap;

    public NettyClient(URL url) {
        super(url);
        this.fusingThreshold = url.getIntParameter(URLParamType.fusingThreshold.getName(), URLParamType.fusingThreshold.getIntValue());
        this.timeMonitorFuture = scheduledExecutor.scheduleWithFixedDelay(new TimeoutMonitor("timeout_monitor_" + url.getHost() + "_" + url.getPort()), 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public Response request(Request request) throws TransportException {
        if (!this.isAvailable()) {
            throw new MotanServiceException("NettyChannel is unavaliable: url=" + this.url.getUri() + MotanFrameworkUtil.toString((Request)request));
        }
        boolean isAsync = false;
        Object async = RpcContext.getContext().getAttribute((Object)"Async");
        if (async != null && async instanceof Boolean) {
            isAsync = (Boolean)async;
        }
        return this.request(request, isAsync);
    }

    public void heartbeat(Request request) {
        if (this.state.isUnInitState() || this.state.isCloseState()) {
            LoggerUtil.warn((String)"NettyClient heartbeat Error: state={} url={}", (Object[])new Object[]{this.state.name(), this.url.getUri()});
            return;
        }
        LoggerUtil.info((String)"NettyClient heartbeat request: url={}", (Object[])new Object[]{this.url.getUri()});
        try {
            this.request(request, true);
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyClient heartbeat Error: url=" + this.url.getUri() + ", " + e.getMessage()));
        }
    }

    private Response request(Request request, boolean async) throws TransportException {
        Channel channel = null;
        Response response = null;
        try {
            channel = this.borrowObject();
            MotanFrameworkUtil.logEvent((Request)request, (String)"TRACE_CONNECTION");
            if (channel == null) {
                LoggerUtil.error((String)("NettyClient borrowObject null: url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString((Request)request)));
                return null;
            }
            response = channel.request(request);
            this.returnObject(channel);
        }
        catch (Exception e) {
            this.invalidateObject(channel);
            if (e instanceof MotanAbstractException) {
                throw (MotanAbstractException)e;
            }
            throw new MotanServiceException("NettyClient request Error: url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString((Request)request), (Throwable)e);
        }
        response = this.asyncResponse(response, async);
        return response;
    }

    private Response asyncResponse(Response response, boolean async) {
        if (async || !(response instanceof ResponseFuture)) {
            return response;
        }
        return new DefaultResponse(response);
    }

    public synchronized boolean open() {
        if (this.isAvailable()) {
            return true;
        }
        this.initClientBootstrap();
        this.initPool();
        LoggerUtil.info((String)"NettyClient finish Open: url={}", (Object[])new Object[]{this.url});
        StatsUtil.registryStatisticCallback((StatisticCallback)this);
        this.state = ChannelState.ALIVE;
        return this.state.isAliveState();
    }

    private void initClientBootstrap() {
        this.bootstrap = new ClientBootstrap(channelFactory);
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        int timeout = this.getUrl().getIntParameter(URLParamType.connectTimeout.getName(), URLParamType.connectTimeout.getIntValue());
        if (timeout <= 0) {
            throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.bootstrap.setOption("connectTimeoutMillis", (Object)timeout);
        final int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyDecoder(NettyClient.this.codec, (Channel)NettyClient.this, maxContentLength));
                pipeline.addLast("encoder", (ChannelHandler)new NettyEncoder(NettyClient.this.codec, (Channel)NettyClient.this));
                pipeline.addLast("handler", (ChannelHandler)new NettyChannelHandler((Channel)NettyClient.this, new MessageHandler(){

                    public Object handle(Channel channel, Object message) {
                        Response response = (Response)message;
                        ResponseFuture responseFuture = NettyClient.this.removeCallback(response.getRequestId());
                        if (responseFuture == null) {
                            LoggerUtil.warn((String)"NettyClient has response from server, but resonseFuture not exist,  requestId={}", (Object[])new Object[]{response.getRequestId()});
                            return null;
                        }
                        if (response.getException() != null) {
                            responseFuture.onFailure(response);
                        } else {
                            responseFuture.onSuccess(response);
                        }
                        return null;
                    }
                }));
                return pipeline;
            }
        });
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        if (this.state.isCloseState()) {
            return;
        }
        try {
            this.cleanup();
            if (this.state.isUnInitState()) {
                LoggerUtil.info((String)"NettyClient close fail: state={}, url={}", (Object[])new Object[]{this.state.value, this.url.getUri()});
                return;
            }
            this.state = ChannelState.CLOSE;
            LoggerUtil.info((String)"NettyClient close Success: url={}", (Object[])new Object[]{this.url.getUri()});
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyClient close Error: url=" + this.url.getUri()), (Throwable)e);
        }
    }

    public void cleanup() throws Exception {
        this.timeMonitorFuture.cancel(true);
        if (this.pool != null) {
            this.pool.close();
        }
        this.callbackMap.clear();
        StatsUtil.unRegistryStatisticCallback((StatisticCallback)this);
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState();
    }

    public URL getUrl() {
        return this.url;
    }

    protected BasePoolableObjectFactory createChannelFactory() {
        return new NettyChannelFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrErrorCount() {
        long count = this.errorCount.incrementAndGet();
        if (count >= (long)this.fusingThreshold && this.state.isAliveState()) {
            NettyClient nettyClient = this;
            synchronized (nettyClient) {
                count = this.errorCount.longValue();
                if (count >= (long)this.fusingThreshold && this.state.isAliveState()) {
                    LoggerUtil.error((String)("NettyClient unavailable Error: url=" + this.url.getIdentity() + " " + this.url.getServerPortStr()));
                    this.state = ChannelState.UNALIVE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetErrorCount() {
        this.errorCount.set(0L);
        if (this.state.isAliveState()) {
            return;
        }
        NettyClient nettyClient = this;
        synchronized (nettyClient) {
            long count;
            if (this.state.isAliveState()) {
                return;
            }
            if (this.state.isUnAliveState() && (count = this.errorCount.longValue()) < (long)this.fusingThreshold) {
                this.state = ChannelState.ALIVE;
                LoggerUtil.info((String)("NettyClient recover available: url=" + this.url.getIdentity() + " " + this.url.getServerPortStr()));
            }
        }
    }

    public void registerCallback(long requestId, ResponseFuture nettyResponseFuture) {
        if (this.callbackMap.size() >= 20000) {
            throw new MotanServiceException("NettyClient over of max concurrent request, drop request, url: " + this.url.getUri() + " requestId=" + requestId, MotanErrorMsgConstant.SERVICE_REJECT, false);
        }
        this.callbackMap.put(requestId, nettyResponseFuture);
    }

    public String statisticCallback() {
        if (this.isAvailable() && this.callbackMap.size() < 100) {
            return null;
        }
        return String.format("type:MOTAN_CLUSTER_NODE_STAT, name:%s_%s, ip:%s, port:%s, available: %s, request_count: %s", this.url.getGroup(), this.url.getPath(), this.url.getHost(), this.url.getPort(), this.isAvailable(), this.callbackMap.size());
    }

    public ResponseFuture removeCallback(long requestId) {
        return (ResponseFuture)this.callbackMap.remove(requestId);
    }

    public ClientBootstrap getBootstrap() {
        return this.bootstrap;
    }

    class TimeoutMonitor
    implements Runnable {
        private String name;

        public TimeoutMonitor(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : NettyClient.this.callbackMap.entrySet()) {
                try {
                    ResponseFuture future = (ResponseFuture)entry.getValue();
                    if (future.getCreateTime() + (long)future.getTimeout() >= currentTime) continue;
                    NettyClient.this.removeCallback((Long)entry.getKey());
                    future.cancel();
                }
                catch (Exception e) {
                    LoggerUtil.error((String)(this.name + " clear timeout future Error: uri=" + NettyClient.this.url.getUri() + " requestId=" + entry.getKey()), (Throwable)e);
                }
            }
        }
    }
}

