/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty.NettyClient;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelFuture;

public class NettyChannel
implements Channel {
    private volatile ChannelState state = ChannelState.UNINIT;
    private NettyClient nettyClient;
    private org.jboss.netty.channel.Channel channel = null;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress = null;

    public NettyChannel(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
        this.remoteAddress = new InetSocketAddress(nettyClient.getUrl().getHost(), (int)nettyClient.getUrl().getPort());
    }

    public Response request(Request request) throws TransportException {
        int timeout = 0;
        if (request.getAttachments().get("M_tmo") != null) {
            timeout = MathUtil.parseInt((String)((String)request.getAttachments().get("M_tmo")), (int)0);
        }
        if (timeout == 0) {
            timeout = this.nettyClient.getUrl().getMethodParameter(request.getMethodName(), request.getParamtersDesc(), URLParamType.requestTimeout.getName(), URLParamType.requestTimeout.getIntValue());
        }
        if (timeout <= 0) {
            throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        DefaultResponseFuture response = new DefaultResponseFuture(request, timeout, this.nettyClient.getUrl());
        this.nettyClient.registerCallback(request.getRequestId(), (ResponseFuture)response);
        ChannelFuture writeFuture = this.channel.write((Object)request);
        boolean result = writeFuture.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS);
        if (result && writeFuture.isSuccess()) {
            MotanFrameworkUtil.logEvent((Request)request, (String)"TRACE_CSEND", (long)System.currentTimeMillis());
            response.addListener(future -> {
                if (future.isSuccess() || future.isDone() && ExceptionUtil.isBizException((Exception)future.getException())) {
                    this.nettyClient.resetErrorCount();
                } else {
                    this.nettyClient.incrErrorCount(future.getException());
                }
            });
            return response;
        }
        writeFuture.cancel();
        response = this.nettyClient.removeCallback(request.getRequestId());
        if (response != null) {
            response.cancel();
        }
        this.nettyClient.incrErrorCount(null);
        if (writeFuture.getCause() != null) {
            throw new MotanServiceException("NettyChannel send request to server Error: url=" + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress + " " + MotanFrameworkUtil.toString((Request)request), writeFuture.getCause());
        }
        throw new MotanServiceException("NettyChannel send request to server Timeout: url=" + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress + " " + MotanFrameworkUtil.toString((Request)request), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean open() {
        if (this.isAvailable()) {
            LoggerUtil.warn((String)("the channel already open, local: " + this.localAddress + " remote: " + this.remoteAddress + " url: " + this.nettyClient.getUrl().getUri()));
            return true;
        }
        ChannelFuture channelFuture = null;
        try {
            NettyChannel nettyChannel = this;
            // MONITORENTER : nettyChannel
            channelFuture = this.nettyClient.getBootstrap().connect((SocketAddress)new InetSocketAddress(this.nettyClient.getUrl().getHost(), (int)this.nettyClient.getUrl().getPort()));
            long start = System.currentTimeMillis();
            int timeout = this.nettyClient.getUrl().getIntParameter(URLParamType.connectTimeout.getName(), URLParamType.connectTimeout.getIntValue());
            if (timeout <= 0) {
                throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
            }
            boolean result = channelFuture.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS);
            boolean success = channelFuture.isSuccess();
            if (result && success) {
                this.channel = channelFuture.getChannel();
                if (this.channel.getLocalAddress() != null && this.channel.getLocalAddress() instanceof InetSocketAddress) {
                    this.localAddress = (InetSocketAddress)this.channel.getLocalAddress();
                }
                this.state = ChannelState.ALIVE;
                boolean bl = true;
                // MONITOREXIT : nettyChannel
                return bl;
            }
            boolean connected = false;
            if (channelFuture.getChannel() != null) {
                connected = channelFuture.getChannel().isConnected();
            }
            if (channelFuture.getCause() != null) {
                channelFuture.cancel();
                throw new MotanServiceException("NettyChannel failed to connect to server, url: " + this.nettyClient.getUrl().getUri() + ", result: " + result + ", success: " + success + ", connected: " + connected, channelFuture.getCause());
            }
            channelFuture.cancel();
            throw new MotanServiceException("NettyChannel connect to server timeout url: " + this.nettyClient.getUrl().getUri() + ", cost: " + (System.currentTimeMillis() - start) + ", result: " + result + ", success: " + success + ", connected: " + connected, false);
        }
        catch (MotanServiceException e) {
            throw e;
        }
        catch (Exception e) {
            if (channelFuture == null) throw new MotanServiceException("NettyChannel failed to connect to server, url: " + this.nettyClient.getUrl().getUri(), (Throwable)e);
            channelFuture.getChannel().close();
            throw new MotanServiceException("NettyChannel failed to connect to server, url: " + this.nettyClient.getUrl().getUri(), (Throwable)e);
        }
        finally {
            if (!this.state.isAliveState()) {
                this.nettyClient.incrErrorCount(2, false);
            }
        }
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        try {
            this.state = ChannelState.CLOSE;
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyChannel close Error: " + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress), (Throwable)e);
        }
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState() && this.channel != null && this.channel.isConnected();
    }

    public URL getUrl() {
        return this.nettyClient.getUrl();
    }
}

