/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty.admin;

import com.weibo.api.motan.admin.AbstractAdminServer;
import com.weibo.api.motan.admin.AdminHandler;
import com.weibo.api.motan.admin.AdminUtil;
import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.netty.StandardThreadExecutor;
import com.weibo.api.motan.util.LoggerUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

public class AdminHttpServer
extends AbstractAdminServer {
    private static final ChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("AdminHttpServerBoss", true)), (Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("AdminHttpServerWorker", true)));
    private StandardThreadExecutor standardThreadExecutor = null;
    private Channel serverChannel;
    private volatile ChannelState state = ChannelState.UNINIT;

    public AdminHttpServer(URL url, AdminHandler adminHandler) {
        this.url = url;
        this.adminHandler = adminHandler;
    }

    public boolean open() {
        if (this.state.isAliveState()) {
            return true;
        }
        int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        this.standardThreadExecutor = this.standardThreadExecutor != null && !this.standardThreadExecutor.isShutdown() ? this.standardThreadExecutor : new StandardThreadExecutor(5, 50, 500, (ThreadFactory)new DefaultThreadFactory("AdminHttpServer-" + this.url.getServerPortStr(), true));
        this.standardThreadExecutor.prestartAllCoreThreads();
        ServerBootstrap bootstrap = new ServerBootstrap(channelFactory);
        bootstrap.setPipelineFactory(() -> {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, maxContentLength));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("nettyChannelHandler", (ChannelHandler)new SimpleChannelUpstreamHandler(){

                public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
                    try {
                        AdminHttpServer.this.standardThreadExecutor.execute(() -> AdminHttpServer.this.processHttpRequest(event));
                    }
                    catch (Exception e) {
                        LoggerUtil.error((String)"AdminHttpServer request is rejected by threadPool!", (Throwable)e);
                        AdminHttpServer.this.sendResponse(event.getChannel(), AdminHttpServer.this.buildErrorResponse(AdminUtil.toJsonErrorMessage((String)"request is rejected by thread pool")));
                    }
                }
            });
            return pipeline;
        });
        try {
            this.serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(this.url.getPort()));
            if (this.url.getPort() == 0) {
                this.url.setPort(((InetSocketAddress)this.serverChannel.getLocalAddress()).getPort());
            }
            this.state = ChannelState.ALIVE;
            LoggerUtil.info((String)("AdminHttpServer Open: url=" + this.url));
            return true;
        }
        catch (Exception e) {
            LoggerUtil.error((String)("AdminHttpServer Open fail: url=" + this.url), (Throwable)e);
            return false;
        }
    }

    private void processHttpRequest(MessageEvent event) {
        HttpResponse httpResponse;
        try {
            HttpRequest httpRequest = (HttpRequest)event.getMessage();
            httpRequest.setHeader(URLParamType.host.getName(), (Object)((InetSocketAddress)event.getChannel().getRemoteAddress()).getAddress().getHostAddress());
            httpResponse = this.convertHttpResponse(this.adminHandler.handle(this.convertRequest(httpRequest)));
        }
        catch (Exception e) {
            LoggerUtil.error((String)"AdminHttpServer convert request fail.", (Throwable)e);
            httpResponse = this.buildErrorResponse(AdminUtil.toJsonErrorMessage((String)e.getMessage()));
        }
        this.sendResponse(event.getChannel(), httpResponse);
    }

    Request convertRequest(HttpRequest httpRequest) {
        DefaultRequest request = new DefaultRequest();
        ConcurrentHashMap params = new ConcurrentHashMap();
        QueryStringDecoder decoder = new QueryStringDecoder(httpRequest.getUri());
        for (Map.Entry entry : decoder.getParameters().entrySet()) {
            params.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        request.setMethodName(decoder.getPath());
        decoder = new QueryStringDecoder("?" + httpRequest.getContent().toString(StandardCharsets.UTF_8));
        for (Map.Entry entry : decoder.getParameters().entrySet()) {
            params.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        request.setArguments(new Object[]{params});
        for (Map.Entry entry : httpRequest.getHeaders()) {
            request.setAttachment((String)entry.getKey(), (String)entry.getValue());
        }
        return request;
    }

    HttpResponse convertHttpResponse(Response response) {
        if (response.getException() != null) {
            String errMsg = response.getException() instanceof MotanAbstractException ? ((MotanAbstractException)response.getException()).getOriginMessage() : response.getException().getMessage();
            return this.buildErrorResponse(errMsg);
        }
        return this.buildOkResponse(response.getValue().toString());
    }

    private HttpResponse buildErrorResponse(String errorMessage) {
        return this.buildHttpResponse(errorMessage.getBytes(StandardCharsets.UTF_8), HttpResponseStatus.SERVICE_UNAVAILABLE);
    }

    private HttpResponse buildOkResponse(String content) {
        return this.buildHttpResponse(content.getBytes(StandardCharsets.UTF_8), HttpResponseStatus.OK);
    }

    private HttpResponse buildHttpResponse(byte[] content, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        DynamicChannelBuffer responseBuffer = new DynamicChannelBuffer(content.length);
        responseBuffer.writeBytes(content);
        response.setContent((ChannelBuffer)responseBuffer);
        response.setHeader("Content-Type", (Object)"text/html; charset=UTF-8");
        response.setHeader("Content-Length", (Object)responseBuffer.writerIndex());
        return response;
    }

    private void sendResponse(Channel ch, HttpResponse response) {
        try {
            ChannelFuture f = ch.write((Object)response);
            f.addListener(future -> future.getChannel().close());
        }
        catch (Exception e) {
            LoggerUtil.error((String)"AdminHttpServer send response fail.", (Throwable)e);
            ch.close();
        }
    }

    public void close() {
        if (this.state.isCloseState()) {
            return;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        if (this.standardThreadExecutor != null) {
            this.standardThreadExecutor.shutdownNow();
            this.standardThreadExecutor = null;
        }
        this.state = ChannelState.CLOSE;
        LoggerUtil.info((String)"AdminHttpServer close Success: url={}", (Object[])new Object[]{this.url.getUri()});
    }
}

