/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty.admin;

import com.weibo.api.motan.admin.AdminHandler;
import com.weibo.api.motan.admin.AdminServer;
import com.weibo.api.motan.admin.AdminServerFactory;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.netty.admin.AdminHttpServer;
import com.weibo.api.motan.transport.netty.admin.AdminRpcServer;

@SpiMeta(name="netty3")
public class NettyAdminServerFactory
implements AdminServerFactory {
    public AdminServer createServer(URL url, AdminHandler adminHandler) {
        if (adminHandler == null) {
            throw new MotanFrameworkException("AdminHandler can not be null");
        }
        String protocol = url.getProtocol();
        if ("http".equals(protocol)) {
            return new AdminHttpServer(url, adminHandler);
        }
        if ("motan2".equals(protocol)) {
            return new AdminRpcServer(url, adminHandler);
        }
        throw new MotanFrameworkException("unsupported admin server protocol: " + protocol);
    }
}

