/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar.yarserver;

import com.weibo.yar.yarserver.HttpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;

public class NettyYarServer {
    public static void main(String[] args) throws Exception {
        NettyYarServer server = new NettyYarServer();
        System.out.println("Http Server listening on 8844 ...");
        server.start(8844);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                    ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                    ch.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                    ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                    ch.pipeline().addLast("serverHandler", (ChannelHandler)new HttpServerHandler());
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind(port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

